/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.netxms.nxmc.base.widgets.Card;
import org.netxms.nxmc.base.widgets.helpers.DashboardElementButton;
import org.netxms.nxmc.base.widgets.helpers.ExpansionEvent;
import org.netxms.nxmc.base.widgets.helpers.ExpansionListener;
import org.netxms.nxmc.resources.SharedIcons;

public class Section
extends Card {
    private Composite clientArea;
    private DashboardElementButton expandButton;
    private boolean expanded = true;
    private Set<ExpansionListener> expansionListeners = new HashSet();

    public Section(Composite parent, String title, boolean collapsible) {
        super(parent, title);
        if (collapsible) {
            this.expandButton = new DashboardElementButton("Collapse", SharedIcons.IMG_COLLAPSE, (Action)new /* Unavailable Anonymous Inner Class!! */);
            this.addButton(this.expandButton);
        }
    }

    protected Control createClientArea(Composite parent) {
        this.clientArea = new Composite(parent, 0);
        this.clientArea.setLayout((Layout)new FillLayout());
        return this.clientArea;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded == expanded) {
            return;
        }
        this.expanded = expanded;
        this.expandButton.setImage(expanded ? SharedIcons.IMG_COLLAPSE : SharedIcons.IMG_EXPAND);
        this.expandButton.setName(expanded ? "Collapse" : "Expand");
        this.updateButtons();
        this.showClientArea(expanded);
        ExpansionEvent e = new ExpansionEvent((Widget)this, expanded);
        for (ExpansionListener l : this.expansionListeners) {
            l.expansionStateChanged(e);
        }
        this.getParent().layout(true, true);
    }

    public void addExpansionListener(ExpansionListener listener) {
        this.expansionListeners.add(listener);
    }

    public void removeExpansionListener(ExpansionListener listener) {
        this.expansionListeners.remove(listener);
    }

    public Composite getClient() {
        return this.clientArea;
    }
}

