/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.Date;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.ScheduledTask;
import org.netxms.nxmc.base.widgets.DateTimeSelector;
import org.netxms.nxmc.base.widgets.ScheduleEditor;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class ScheduleEditor
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(ScheduleEditor.class);
    private Button radioOneTimeSchedule;
    private Button radioRecurrent;
    private DateTimeSelector execDateSelector;
    private Text textSchedule;

    public ScheduleEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 16;
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.radioOneTimeSchedule = new Button((Composite)this, 16);
        this.radioOneTimeSchedule.setText(this.i18n.tr("One time execution"));
        this.radioOneTimeSchedule.setSelection(true);
        this.radioOneTimeSchedule.addSelectionListener((SelectionListener)listener);
        this.execDateSelector = new DateTimeSelector((Composite)this, 0);
        this.execDateSelector.setValue(new Date());
        this.radioRecurrent = new Button((Composite)this, 16);
        this.radioRecurrent.setText(this.i18n.tr("Recurrent"));
        this.radioRecurrent.setSelection(false);
        this.radioRecurrent.addSelectionListener((SelectionListener)listener);
        this.textSchedule = new Text((Composite)this, 2048);
        this.textSchedule.setTextLimit(255);
        this.textSchedule.setText("");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textSchedule.setLayoutData((Object)gd);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.radioOneTimeSchedule.setEnabled(enabled);
        this.radioRecurrent.setEnabled(enabled);
        if (enabled) {
            this.execDateSelector.setEnabled(this.radioOneTimeSchedule.getSelection());
            this.textSchedule.setEnabled(this.radioRecurrent.getSelection());
        } else {
            this.execDateSelector.setEnabled(false);
            this.textSchedule.setEnabled(false);
        }
    }

    public ScheduledTask getSchedule() {
        return new ScheduledTask("Dummy", this.radioRecurrent.getSelection() ? this.textSchedule.getText() : "", "", "", this.execDateSelector.getValue(), 0, 0L);
    }

    public void setSchedule(ScheduledTask scheduledTask) {
        if (scheduledTask.getSchedule().isEmpty()) {
            this.radioOneTimeSchedule.setSelection(true);
            this.textSchedule.setEnabled(false);
            this.execDateSelector.setEnabled(true);
            this.execDateSelector.setValue(scheduledTask.getExecutionTime());
        } else {
            this.radioOneTimeSchedule.setSelection(false);
            this.radioRecurrent.setSelection(true);
            this.textSchedule.setEnabled(true);
            this.execDateSelector.setEnabled(false);
            this.textSchedule.setText(scheduledTask.getSchedule());
        }
    }
}

