/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views.helpers;

public class NavigationHistory {
    private static final int HISTORY_SIZE = 64;
    private Object[] history = new Object[64];
    private int size = 0;
    private int position = -1;
    private int bufferPosition = 0;
    private boolean locked = false;

    public void add(Object selection) {
        if (this.locked) {
            return;
        }
        this.history[this.bufferPosition++] = selection;
        if (this.bufferPosition == 64) {
            this.bufferPosition = 0;
        }
        if (this.position < 63) {
            ++this.position;
        }
        this.size = this.position + 1;
    }

    public Object back() {
        if (this.position < 1) {
            return null;
        }
        --this.position;
        --this.bufferPosition;
        if (this.bufferPosition < 0) {
            this.bufferPosition = 63;
        }
        return this.history[this.bufferPosition > 0 ? this.bufferPosition - 1 : 63];
    }

    public Object forward() {
        if (this.position >= this.size - 1) {
            return null;
        }
        ++this.position;
        Object e = this.history[this.bufferPosition++];
        if (this.bufferPosition == 64) {
            this.bufferPosition = 0;
        }
        return e;
    }

    public boolean canGoBackward() {
        return this.position > 0;
    }

    public boolean canGoForward() {
        return this.position < this.size - 1;
    }

    public void clear() {
        this.size = 0;
        this.position = -1;
        this.bufferPosition = 0;
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public String toString() {
        return "NavigationHistory [size=" + this.size + ", position=" + this.position + ", bufferPosition=" + this.bufferPosition + "]";
    }
}

