/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.ViewContainer;
import org.netxms.nxmc.base.views.ViewFolder;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.views.ViewStateListener;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.base.widgets.MessageArea;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.base.widgets.ProgressArea;
import org.netxms.nxmc.base.windows.PopOutViewWindow;
import org.netxms.nxmc.keyboard.KeyBindingManager;
import org.netxms.nxmc.keyboard.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class View
implements MessageAreaHolder {
    protected static final int DEFAULT_PRIORITY = 65535;
    private static final Logger logger = LoggerFactory.getLogger(View.class);
    private String baseId;
    private String name;
    private ImageDescriptor imageDescriptor;
    private Image image;
    private ViewContainer viewContainer;
    private Composite viewArea;
    private MessageArea messageArea;
    private FilterText filterText;
    private Composite clientArea;
    private ProgressArea progressArea;
    private boolean hasFilter;
    private boolean showFilterTooltip;
    private boolean showFilterLabel;
    private boolean filterEnabled;
    private boolean refreshEnabled;
    private AbstractViewerFilter filter;
    private ISelectionProvider viewer;
    private Set<ViewStateListener> stateListeners = new HashSet();
    private KeyBindingManager keyBindingManager = new KeyBindingManager();
    private View originalView;

    public View(String name, ImageDescriptor image, String baseId) {
        this(name, image, baseId, false, false, false);
    }

    public View(String name, ImageDescriptor image, String baseId, boolean hasFilter) {
        this(name, image, baseId, hasFilter, false, false);
    }

    public View(String name, ImageDescriptor image, String baseId, boolean hasFilter, boolean showFilterTooltip, boolean showFilterLabel) {
        this.baseId = baseId;
        this.name = name;
        this.imageDescriptor = image;
        this.hasFilter = hasFilter;
        this.showFilterTooltip = showFilterTooltip;
        this.showFilterLabel = showFilterLabel;
        this.refreshEnabled = true;
    }

    public View cloneView() {
        try {
            Constructor<?> constructor = this.getClass().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            View view = (View)constructor.newInstance(new Object[0]);
            view.baseId = this.baseId;
            view.name = this.name;
            view.imageDescriptor = this.imageDescriptor;
            view.hasFilter = this.hasFilter;
            view.showFilterTooltip = this.showFilterTooltip;
            view.showFilterLabel = this.showFilterLabel;
            view.filterEnabled = this.filterEnabled;
            view.originalView = this;
            return view;
        }
        catch (Exception e) {
            logger.error("Cannot clone view", (Throwable)e);
            return null;
        }
    }

    protected void postClone(View view) {
        String[] filterText = new String[1];
        view.getDisplay().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.setFilterText(filterText[0]);
    }

    protected final void create(ViewContainer viewContainer, Composite parent, Runnable onFilterCloseCallback) {
        this.viewContainer = viewContainer;
        if (this.imageDescriptor != null) {
            this.image = this.imageDescriptor.createImage();
        }
        this.viewArea = new Composite(parent, 0);
        this.viewArea.setLayout((Layout)new FormLayout());
        this.messageArea = new MessageArea(this.viewArea, 0);
        if (this.hasFilter) {
            this.filterText = new FilterText(this.viewArea, 0, this.showFilterTooltip ? "" : null, true, this.showFilterLabel);
            this.filterText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            this.filterText.setCloseCallback(onFilterCloseCallback);
        }
        this.clientArea = new Composite(this.viewArea, 0);
        this.clientArea.setLayout((Layout)new FillLayout());
        this.progressArea = new ProgressArea(this.viewArea, 0);
        this.createContent(this.clientArea);
        if (this.originalView != null) {
            this.postClone(this.originalView);
            this.originalView = null;
        } else {
            this.postContentCreate();
        }
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.messageArea.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        this.progressArea.setLayoutData((Object)fd);
        if (this.hasFilter) {
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment((Control)this.messageArea);
            fd.right = new FormAttachment(100, 0);
            this.filterText.setLayoutData((Object)fd);
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment((Control)this.filterText);
            fd.right = new FormAttachment(100, 0);
            fd.bottom = new FormAttachment((Control)this.progressArea);
            this.clientArea.setLayoutData((Object)fd);
            this.filterEnabled = PreferenceStore.getInstance().getAsBoolean(this.getBaseId() + ".showFilter", true);
            if (!this.filterEnabled) {
                this.enableFilter(false);
            }
        } else {
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment((Control)this.messageArea);
            fd.right = new FormAttachment(100, 0);
            fd.bottom = new FormAttachment((Control)this.progressArea);
            this.clientArea.setLayoutData((Object)fd);
        }
    }

    protected abstract void createContent(Composite var1);

    protected void postContentCreate() {
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
    }

    protected void fillLocalMenu(IMenuManager manager) {
    }

    public int addMessage(int level, String text) {
        return this.messageArea.addMessage(level, text);
    }

    public int addMessage(int level, String text, boolean sticky, String buttonText, Runnable action) {
        return this.messageArea.addMessage(level, text, sticky, buttonText, action);
    }

    public int addMessage(int level, String text, boolean sticky) {
        return this.messageArea.addMessage(level, text, sticky);
    }

    public void deleteMessage(int id) {
        this.messageArea.deleteMessage(id);
    }

    public void clearMessages() {
        this.messageArea.clearMessages();
    }

    public void activate() {
        this.viewArea.moveAbove(null);
        this.viewArea.layout(true, true);
        for (ViewStateListener listener : new ArrayList(this.stateListeners)) {
            listener.viewActivated(this);
        }
    }

    public void deactivate() {
        for (ViewStateListener listener : new ArrayList(this.stateListeners)) {
            listener.viewDeactivated(this);
        }
    }

    public void setFocus() {
        if (this.hasFilter && this.filterEnabled) {
            this.filterText.setFocus();
        } else if (this.viewer != null && this.viewer instanceof StructuredViewer) {
            ((StructuredViewer)this.viewer).getControl().setFocus();
        } else {
            this.viewArea.setFocus();
        }
    }

    public boolean beforeClose() {
        return true;
    }

    public void dispose() {
        logger.debug("View disposed - " + this.getGlobalId());
        for (ViewStateListener listener : new ArrayList(this.stateListeners)) {
            listener.viewClosed(this);
        }
        this.stateListeners.clear();
        if (this.viewArea != null && !this.viewArea.isDisposed()) {
            this.viewArea.dispose();
            this.viewArea = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public boolean isCreated() {
        return this.viewArea != null;
    }

    public String getName() {
        return this.name != null ? this.name : "[" + this.baseId + "]";
    }

    public String getFullName() {
        return this.getName();
    }

    public void setName(String name) {
        this.name = name;
        if (this.viewContainer != null) {
            if (this.viewContainer.getPerspective() != null) {
                this.viewContainer.getPerspective().updateViewTrim(this);
            } else if (this.viewContainer instanceof ViewFolder) {
                ((ViewFolder)this.viewContainer).updateViewTrim(this);
            } else if (this.viewContainer.getWindow() != null) {
                this.viewContainer.getWindow().getShell().setText(this.getFullName());
            }
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
        if (this.image != null) {
            this.image.dispose();
        }
        Image image = this.image = imageDescriptor != null ? imageDescriptor.createImage() : null;
        if (this.viewContainer != null) {
            if (this.viewContainer.getPerspective() != null) {
                this.viewContainer.getPerspective().updateViewTrim(this);
            } else if (this.viewContainer instanceof ViewFolder) {
                ((ViewFolder)this.viewContainer).updateViewTrim(this);
            }
        }
    }

    public int getPriority() {
        return 65535;
    }

    public Window getWindow() {
        return this.viewContainer != null ? this.viewContainer.getWindow() : null;
    }

    public Perspective getPerspective() {
        return this.viewContainer != null ? this.viewContainer.getPerspective() : null;
    }

    public Composite getViewArea() {
        return this.viewArea;
    }

    public Composite getClientArea() {
        return this.clientArea;
    }

    public void refresh() {
    }

    protected void enableRefresh(boolean enabled) {
        if (this.refreshEnabled != enabled) {
            this.refreshEnabled = enabled;
            if (this.viewContainer != null) {
                this.viewContainer.updateRefreshActionState();
            }
        }
    }

    public boolean isRefreshEnabled() {
        return this.refreshEnabled;
    }

    public void setVisible(boolean visible) {
        if (this.viewArea != null && !this.viewArea.isDisposed()) {
            this.viewArea.setVisible(visible);
        }
    }

    public boolean isVisible() {
        return this.viewArea != null && !this.viewArea.isDisposed() ? this.viewArea.isVisible() : false;
    }

    public boolean isActive() {
        return this.viewContainer.isViewActive(this);
    }

    public String getGlobalId() {
        return this.baseId;
    }

    public String getBaseId() {
        return this.baseId;
    }

    public boolean isCloseable() {
        return false;
    }

    public Display getDisplay() {
        return this.viewArea != null ? this.viewArea.getDisplay() : Display.getCurrent();
    }

    public void addStateListener(ViewStateListener listener) {
        this.stateListeners.add(listener);
    }

    public void removeStateListener(ViewStateListener listener) {
        this.stateListeners.remove(listener);
    }

    public void setFilterTooltip(String tooltip) {
        this.filterText.setTooltip(tooltip);
    }

    public void addFilterModifyListener(ModifyListener listener) {
        if (this.filterText != null) {
            this.filterText.addModifyListener(listener);
        }
    }

    public void removeFilterModifyListener(ModifyListener listener) {
        if (this.filterText != null) {
            this.filterText.removeModifyListener(listener);
        }
    }

    protected void onFilterModify() {
        if (this.filter != null && this.viewer != null) {
            this.defaultOnFilterModify();
        }
    }

    public void setFilterClient(ISelectionProvider viewer, AbstractViewerFilter filter) {
        this.viewer = viewer;
        this.filter = filter;
        if (this.filterText != null && !this.filterText.getText().isEmpty()) {
            this.defaultOnFilterModify();
        }
    }

    private void defaultOnFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        if (this.viewer instanceof StructuredViewer) {
            ((StructuredViewer)this.viewer).refresh(false);
        }
    }

    protected void enableFilter(boolean enable) {
        if (!this.hasFilter) {
            return;
        }
        this.filterEnabled = enable;
        this.filterText.setVisible(enable);
        FormData fd = (FormData)this.clientArea.getLayoutData();
        fd.top = new FormAttachment((Control)(enable ? this.filterText : this.messageArea));
        this.viewArea.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
        PreferenceStore.getInstance().set(this.getBaseId() + ".showFilter", enable);
    }

    protected void enableFilterAutocomplete(IContentProposalProvider proposalProvider) {
        if (this.hasFilter) {
            this.filterText.enableAutoComplete(proposalProvider);
        }
    }

    public boolean hasFilter() {
        return this.hasFilter;
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public String getFilterText() {
        return this.hasFilter && this.filterEnabled ? this.filterText.getText() : null;
    }

    public void setFilterText(String text) {
        if (this.hasFilter && this.filterEnabled) {
            this.filterText.setText(text);
            this.onFilterModify();
        }
    }

    public FilterText getFilterTextControl() {
        return this.filterText;
    }

    public void processKeyStroke(KeyStroke keyStroke) {
        this.keyBindingManager.processKeyStroke(keyStroke);
    }

    protected KeyBindingManager getKeyBindingManager() {
        return this.keyBindingManager;
    }

    public void addKeyBinding(KeyStroke keyStroke, IAction action) {
        this.keyBindingManager.addBinding(keyStroke, action, null);
    }

    public void addKeyBinding(String keyStroke, IAction action) {
        this.keyBindingManager.addBinding(keyStroke, action, null);
    }

    public void addKeyBinding(int modifiers, int key, IAction action) {
        this.keyBindingManager.addBinding(modifiers, key, action, null);
    }

    public void addKeyBinding(KeyStroke keyStroke, IAction action, String radioGroup) {
        this.keyBindingManager.addBinding(keyStroke, action, radioGroup);
    }

    public void addKeyBinding(String keyStroke, IAction action, String radioGroup) {
        this.keyBindingManager.addBinding(keyStroke, action, radioGroup);
    }

    public void addKeyBinding(int modifiers, int key, IAction action, String radioGroup) {
        this.keyBindingManager.addBinding(modifiers, key, action, radioGroup);
    }

    public boolean isClientAreaDisposed() {
        return this.clientArea.isDisposed();
    }

    protected void updateToolBar() {
        if (this.viewContainer != null) {
            this.viewContainer.updateViewToolBar(this);
            this.viewContainer.layout(true, true);
        }
    }

    protected void updateMenu() {
        if (this.viewContainer != null && this.viewContainer.updateViewMenu(this)) {
            this.viewContainer.layout(true, true);
        }
    }

    protected void updateControlBars() {
        if (this.viewContainer != null) {
            this.viewContainer.updateViewToolBar(this);
            this.viewContainer.updateViewMenu(this);
            this.viewContainer.layout(true, true);
        }
    }

    public void openView(View view) {
        if (this.viewContainer == null) {
            return;
        }
        if (this.viewContainer.getPerspective() != null) {
            this.viewContainer.getPerspective().addMainView(view, true);
        } else if (this.viewContainer instanceof ViewFolder) {
            ((ViewFolder)this.viewContainer).addView(view, true, true);
        } else {
            PopOutViewWindow.open((View)view);
        }
    }

    public void saveState(Memento memento) {
        String className = this.getClass().getName();
        memento.set("class", className);
        memento.set("baseId", this.baseId);
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        this.baseId = memento.getAsString("baseId");
    }

    public IProgressMonitor createProgressMonitor(int jobId) {
        return this.progressArea != null ? this.progressArea.createMonitor(jobId) : null;
    }

    public void onJobCompletion(int jobId) {
        if (this.progressArea != null) {
            this.progressArea.removeMonitor(jobId);
        }
    }
}

