/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class CustomTimePeriodDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(CustomTimePeriodDialog.class);
    private int time;
    private Label info;
    private LabeledSpinner days;
    private LabeledSpinner hours;
    private LabeledSpinner minutes;

    public CustomTimePeriodDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(133232);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Set custom timeout"));
        newShell.setSize(350, 220);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.days = new LabeledSpinner(dialogArea, 0);
        this.days.setLabel(this.i18n.tr("Days"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.days.setLayoutData((Object)gridData);
        this.days.setRange(0, 999);
        this.days.setSelection(0);
        this.hours = new LabeledSpinner(dialogArea, 0);
        this.hours.setLabel(this.i18n.tr("Hours"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.hours.setLayoutData((Object)gridData);
        this.hours.setRange(0, 23);
        this.hours.setSelection(0);
        this.minutes = new LabeledSpinner(dialogArea, 0);
        this.minutes.setLabel(this.i18n.tr("Minutes"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.minutes.setLayoutData((Object)gridData);
        this.minutes.setRange(0, 59);
        this.minutes.setSelection(0);
        this.info = new Label(dialogArea, 64);
        this.info.setText(this.i18n.tr("Custom periods can be configured in client preferences (in \"Alarms\" for sticky alarm acknowledgement and in \"Object Maintenance\" for maintenance)"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.info.setLayoutData((Object)gridData);
        return dialogArea;
    }

    protected void okPressed() {
        this.time = this.days.getSelection() * 86400 + this.hours.getSelection() * 3600 + this.minutes.getSelection() * 60;
        if (this.time <= 0) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Time should be greater than zero."));
            return;
        }
        super.okPressed();
    }

    public int getTime() {
        return this.time;
    }
}

