/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import jakarta.servlet.http.Cookie;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.widgets.Display;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.services.PreferenceInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PreferenceStore
extends Memento
implements IPreferenceStore {
    private static final Logger logger = LoggerFactory.getLogger(PreferenceStore.class);
    private static final String COOKIE_NAME = "nxmcStoreId";
    private static final int COOKIE_MAX_AGE_SEC = 7776000;
    private File storeFile;
    private Set<IPropertyChangeListener> changeListeners = new HashSet();

    protected static void open(String stateDir) {
        PreferenceStore instance = new PreferenceStore(new File(stateDir + File.separator + "nxmc.preferences." + PreferenceStore.getStoreId()));
        ServiceLoader<PreferenceInitializer> loader = ServiceLoader.load(PreferenceInitializer.class, PreferenceStore.class.getClassLoader());
        for (PreferenceInitializer pi : loader) {
            logger.debug("Calling preference initializer " + pi.toString());
            try {
                pi.initializeDefaultPreferences(instance);
            }
            catch (Exception e) {
                logger.error("Exception in preference initializer", (Throwable)e);
            }
        }
        RWT.getUISession().setAttribute("netxms.preferenceStore", (Object)instance);
    }

    private static String getStoreId() {
        UISession uiSession = ContextProvider.getUISession();
        String result = (String)uiSession.getAttribute("nxmcStoreId");
        if (result == null) {
            result = PreferenceStore.getStoreIdFromCookie();
            if (result == null) {
                result = UUID.randomUUID().toString();
            }
            Cookie cookie = new Cookie("nxmcStoreId", result);
            cookie.setSecure(ContextProvider.getRequest().isSecure());
            cookie.setMaxAge(7776000);
            cookie.setHttpOnly(true);
            ContextProvider.getResponse().addCookie(cookie);
            uiSession.setAttribute("nxmcStoreId", (Object)result);
        }
        return result;
    }

    private static String getStoreIdFromCookie() {
        String result = null;
        Cookie[] cookies = ContextProvider.getRequest().getCookies();
        if (cookies != null) {
            for (int i = 0; result == null && i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!"nxmcStoreId".equals(cookie.getName())) continue;
                String value = cookie.getValue();
                try {
                    UUID.fromString(value);
                    result = value;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Invalid store ID \"" + value + "\" received from client");
                }
            }
        }
        return result;
    }

    public static PreferenceStore getInstance() {
        return (PreferenceStore)RWT.getUISession().getAttribute("netxms.preferenceStore");
    }

    public static PreferenceStore getInstance(Display display) {
        return (PreferenceStore)RWT.getUISession((Display)display).getAttribute("netxms.preferenceStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreferenceStore(File storeFile) {
        this.storeFile = storeFile;
        if (storeFile.exists()) {
            FileReader reader = null;
            try {
                reader = new FileReader(storeFile);
                this.properties.load(reader);
            }
            catch (Exception e) {
                logger.error("Error reading local preferences from " + storeFile.getAbsolutePath(), (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void save() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.storeFile);
            this.properties.store(writer, "NXMC local preferences");
        }
        catch (Exception e) {
            logger.error("Error writing local preferences to " + this.storeFile.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        Set set = this.changeListeners;
        synchronized (set) {
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        Set set = this.changeListeners;
        synchronized (set) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPropertyChange(String property, String oldValue, String newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, (Object)oldValue, (Object)newValue);
        Set set = this.changeListeners;
        synchronized (set) {
            for (IPropertyChangeListener l : this.changeListeners) {
                l.propertyChange(event);
            }
        }
        this.save();
    }

    public boolean contains(String name) {
        return this.properties.contains(name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.onPropertyChange(name, (String)oldValue, (String)newValue);
    }

    public boolean getBoolean(String name) {
        return this.getAsBoolean(name, false);
    }

    public boolean getDefaultBoolean(String name) {
        String v = this.defaultValues.getProperty(name);
        return v != null ? Boolean.parseBoolean(v) : false;
    }

    public double getDefaultDouble(String name) {
        String v = this.defaultValues.getProperty(name);
        if (v == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public float getDefaultFloat(String name) {
        String v = this.defaultValues.getProperty(name);
        if (v == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(v);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public int getDefaultInt(String name) {
        String v = this.defaultValues.getProperty(name);
        if (v == null) {
            return 0;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public long getDefaultLong(String name) {
        String v = this.defaultValues.getProperty(name);
        if (v == null) {
            return 0L;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String getDefaultString(String name) {
        String v = this.defaultValues.getProperty(name);
        if (v == null) {
            return "";
        }
        return v;
    }

    public double getDouble(String name) {
        return this.getAsDouble(name, 0.0);
    }

    public float getFloat(String name) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return this.getDefaultFloat(name);
        }
        try {
            return Float.parseFloat(v);
        }
        catch (NumberFormatException e) {
            return this.getDefaultFloat(name);
        }
    }

    public int getInt(String name) {
        return this.getAsInteger(name, this.getDefaultInt(name));
    }

    public long getLong(String name) {
        return this.getAsLong(name, this.getDefaultLong(name));
    }

    public String getString(String name) {
        String value = this.getAsString(name);
        return value == null ? "" : value;
    }

    public boolean isDefault(String name) {
        String v = this.defaultValues.getProperty(name);
        return v != null;
    }

    public boolean needsSaving() {
        return false;
    }

    public void putValue(String name, String value) {
        this.set(name, value);
    }

    public void setDefault(String name, double value) {
        this.setDefault(name, value);
    }

    public void setDefault(String name, float value) {
        this.setDefault(name, value);
    }

    public void setToDefault(String name) {
        this.set(name, this.getDefaultString(name));
    }

    public void setValue(String name, double value) {
        this.set(name, value);
    }

    public void setValue(String name, float value) {
        this.set(name, (double)value);
    }

    public void setValue(String name, int value) {
        this.set(name, value);
    }

    public void setValue(String name, long value) {
        this.set(name, value);
    }

    public void setValue(String name, String value) {
        this.set(name, value);
    }

    public void setValue(String name, boolean value) {
        this.set(name, value);
    }
}

