/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FontTools {
    private static final String[] TITLE_FONTS = new String[]{"Segoe UI", "Liberation Sans", "DejaVu Sans", ".AppleSystemUIFont", "Verdana", "Arial"};
    private static Logger logger = LoggerFactory.getLogger(FontTools.class);
    private static Set<String> availableFonts = null;
    private static Map<String, Font> fontCache = new HashMap();

    public static String findFirstAvailableFont(String[] names) {
        if (availableFonts == null) {
            FontData[] fonts;
            logger.debug("Loading list of available fonts");
            availableFonts = new HashSet();
            FontData[] fontDataArray = fonts = Display.getCurrent().getFontList(null, true);
            int n = fontDataArray.length;
            for (int i = 0; i < n; ++i) {
                FontData fd = fontDataArray[i];
                availableFonts.add(fd.getName().toUpperCase());
            }
        }
        for (String name : names) {
            if (!availableFonts.contains(name.trim().toUpperCase())) continue;
            logger.debug("Selected font " + name);
            return name;
        }
        return null;
    }

    public static Font getFont(String[] names, int heightAdjustment, int style) {
        String name = FontTools.findFirstAvailableFont((String[])names);
        if (name == null) {
            return null;
        }
        String key = name + "/A=" + heightAdjustment + "/" + style;
        Font f = (Font)fontCache.get(key);
        if (f != null) {
            return f;
        }
        f = new Font((Device)Display.getCurrent(), name, JFaceResources.getDefaultFont().getFontData()[0].getHeight() + heightAdjustment, style);
        fontCache.put(key, f);
        return f;
    }

    public static Font[] getFonts(String[] names, int baseHeight, int style, int count) {
        String name = FontTools.findFirstAvailableFont((String[])names);
        if (name == null) {
            return null;
        }
        Font[] fonts = new Font[count];
        for (int i = 0; i < count; ++i) {
            int height = baseHeight + i;
            String key = name + "/H=" + height + "/" + style;
            Font f = (Font)fontCache.get(key);
            if (f == null) {
                f = new Font((Device)Display.getCurrent(), name, height, style);
                fontCache.put(key, f);
            }
            fonts[i] = f;
        }
        return fonts;
    }

    public static Font createFont(String[] names, Font baseFont, int heightAdjustment, int style) {
        String name = FontTools.findFirstAvailableFont((String[])names);
        if (name == null) {
            return null;
        }
        return new Font((Device)Display.getCurrent(), name, baseFont.getFontData()[0].getHeight() + heightAdjustment, style);
    }

    public static Font createFont(String[] names, int heightAdjustment, int style) {
        return FontTools.createFont((String[])names, (Font)JFaceResources.getDefaultFont(), (int)heightAdjustment, (int)style);
    }

    public static Font createFont(String[] names, int style) {
        return FontTools.createFont((String[])names, (int)0, (int)style);
    }

    public static Font createTitleFont() {
        return FontTools.createFont((String[])TITLE_FONTS, (int)2, (int)1);
    }

    public static Font createAdjustedFont(Font font, int heightAdjustment) {
        FontData fd = font.getFontData()[0];
        return new Font((Device)Display.getCurrent(), fd.getName(), fd.getHeight() + heightAdjustment, fd.getStyle());
    }

    public static Font createAdjustedFont(Font font, int heightAdjustment, int style) {
        FontData fd = font.getFontData()[0];
        return new Font((Device)Display.getCurrent(), fd.getName(), fd.getHeight() + heightAdjustment, style);
    }
}

