/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.worldmap.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.netxms.base.GeoLocation;
import org.netxms.client.GeoArea;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.worldmap.GeoLocationCache;
import org.netxms.nxmc.modules.worldmap.tools.Area;
import org.netxms.nxmc.modules.worldmap.widgets.AbstractGeoMapViewer;

public class GeoAreaViewer
extends AbstractGeoMapViewer {
    private GeoArea area = null;

    public GeoAreaViewer(Composite parent, int style, View view) {
        super(parent, style, view);
    }

    public void setArea(GeoArea area) {
        this.area = area;
        if (area != null) {
            GeoLocation[] boundingBox = area.getBoundingBox();
            GeoLocation center = new GeoLocation(boundingBox[0].getLatitude() + (boundingBox[1].getLatitude() - boundingBox[0].getLatitude()) / 2.0, boundingBox[0].getLongitude() + (boundingBox[1].getLongitude() - boundingBox[0].getLongitude()) / 2.0);
            int zoom = 0;
            while (zoom < 19) {
                Area coverage = GeoLocationCache.calculateCoverage((Point)this.getSize(), (GeoLocation)center, (int)0, (int)(++zoom));
                if (coverage.contains(boundingBox[0]) && coverage.contains(boundingBox[1])) continue;
                --zoom;
                break;
            }
            this.showMap(center.getLatitude(), center.getLongitude(), zoom);
        }
    }

    protected void onMapLoad() {
    }

    protected void drawContent(GC gc, GeoLocation currentLocation, int imgW, int imgH, int verticalOffset) {
        if (this.area == null) {
            return;
        }
        Point centerXY = GeoLocationCache.coordinateToDisplay((GeoLocation)currentLocation, (int)this.accessor.getZoom());
        gc.setForeground(this.getDisplay().getSystemColor(4));
        gc.setBackground(this.getDisplay().getSystemColor(4));
        int[] points = new int[this.area.getBorder().size() * 2];
        int i = 0;
        for (GeoLocation p : this.area.getBorder()) {
            Point virtualXY = GeoLocationCache.coordinateToDisplay((GeoLocation)p, (int)this.accessor.getZoom());
            int dx = virtualXY.x - centerXY.x;
            int dy = virtualXY.y - centerXY.y;
            points[i++] = imgW / 2 + dx;
            points[i++] = imgH / 2 + dy + verticalOffset;
        }
        gc.setAlpha(40);
        gc.fillPolygon(points);
        gc.setAlpha(255);
        gc.drawPolygon(points);
    }

    protected void onCacheChange(AbstractObject object, GeoLocation prevLocation) {
    }

    public AbstractObject getObjectAtPoint(Point p) {
        return null;
    }
}

