/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.reporting.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.reporting.ReportDefinition;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.client.reporting.ReportRenderFormat;
import org.netxms.client.reporting.ReportResult;
import org.netxms.client.reporting.ReportingJob;
import org.netxms.client.reporting.ReportingJobConfiguration;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.Section;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.reporting.propertypages.General;
import org.netxms.nxmc.modules.reporting.propertypages.Notifications;
import org.netxms.nxmc.modules.reporting.widgets.ReportExecutionForm;
import org.netxms.nxmc.modules.reporting.widgets.ReportFieldEditor;
import org.netxms.nxmc.modules.reporting.widgets.StringFieldEditor;
import org.netxms.nxmc.modules.reporting.widgets.helpers.ReportRenderingHelper;
import org.netxms.nxmc.modules.reporting.widgets.helpers.ReportResultComparator;
import org.netxms.nxmc.modules.reporting.widgets.helpers.ReportResultLabelProvider;
import org.netxms.nxmc.modules.reporting.widgets.helpers.ScheduleLabelProvider;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.services.ReportFieldEditorFactory;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ReportExecutionForm
extends Composite {
    public static final int COLUMN_SCHEDULE_EXEC_TIME = 0;
    public static final int COLUMN_SCHEDULE_OWNER = 1;
    public static final int COLUMN_SCHEDULE_LAST_EXEC_TIME = 2;
    public static final int COLUMN_SCHEDULE_STATUS = 3;
    public static final int COLUMN_RESULT_EXEC_TIME = 0;
    public static final int COLUMN_RESULT_STARTED_BY = 1;
    public static final int COLUMN_RESULT_STATUS = 2;
    private final I18n i18n = LocalizationHelper.getI18n(ReportExecutionForm.class);
    private NXCSession session = Registry.getSession();
    private View view;
    private SortableTableViewer resultList;
    private SortableTableViewer scheduleList;
    private ReportDefinition report;
    private List<ReportParameter> parameters;
    private List<ReportFieldEditor> fields = new ArrayList();
    private Action actionDeleteSchedule;
    private Action actionDeleteResult;
    private Action actionRenderXLSX;
    private Action actionRenderPDF;
    private Action actionViewResult;

    public ReportExecutionForm(Composite parent, int style, ReportDefinition report, View view) {
        super(parent, style);
        this.report = report;
        this.view = view;
        this.createActions();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)layout);
        Section section = new Section((Composite)this, this.i18n.tr("Parameters"), true);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        section.setLayoutData((Object)gd);
        Composite paramArea = new Composite(section.getClient(), 0);
        this.createParamEntryFields(paramArea);
        Composite actionArea = new Composite((Composite)this, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        actionArea.setLayoutData((Object)gd);
        actionArea.setLayout((Layout)new RowLayout(256));
        ImageHyperlink linkExecute = new ImageHyperlink(actionArea, 64);
        linkExecute.setImage(SharedIcons.IMG_EXECUTE);
        linkExecute.setText(this.i18n.tr("Execute now"));
        linkExecute.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkSchedule = new ImageHyperlink(actionArea, 64);
        linkSchedule.setImage(SharedIcons.IMG_CALENDAR);
        linkSchedule.setText(this.i18n.tr("Schedule execution"));
        linkSchedule.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        section = new Section((Composite)this, this.i18n.tr("Results"), false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        this.createResultsSection(section.getClient());
        section = new Section((Composite)this, this.i18n.tr("Schedules"), false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        this.createSchedulesSection(section.getClient());
        3 sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener((SessionListener)sessionListener);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshScheduleList();
        this.refreshResultList();
    }

    private void createActions() {
        this.actionDeleteSchedule = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDeleteSchedule.setEnabled(false);
        this.actionDeleteResult = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDeleteResult.setEnabled(false);
        this.actionRenderPDF = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRenderPDF.setEnabled(false);
        this.actionRenderXLSX = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRenderXLSX.setEnabled(false);
        this.actionViewResult = new /* Unavailable Anonymous Inner Class!! */;
        this.actionViewResult.setEnabled(false);
    }

    private void createSchedulesSection(Composite parent) {
        String[] names = new String[]{"Schedule", "Owner", "Last Run", "Status"};
        int[] widths = new int[]{200, 140, 150, 250};
        this.scheduleList = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.scheduleList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.scheduleList.setLabelProvider((IBaseLabelProvider)new ScheduleLabelProvider((TableViewer)this.scheduleList));
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.scheduleList, (String)"ReportExecutionForm.ScheduleList");
        this.scheduleList.getControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createSchedulesContextMenu();
        this.scheduleList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createSchedulesContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.scheduleList.getControl());
        this.scheduleList.getControl().setMenu(menu);
    }

    private void fillSchedulesContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionDeleteSchedule);
    }

    private void createResultsSection(Composite parent) {
        String[] names = new String[]{"Execution Time", "Started by", "Status"};
        int[] widths = new int[]{180, 140, 100};
        this.resultList = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.resultList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resultList.setLabelProvider((IBaseLabelProvider)new ReportResultLabelProvider(this.resultList));
        this.resultList.setComparator((ViewerComparator)new ReportResultComparator());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.resultList, (String)"ReportExecutionForm.ResultList");
        this.resultList.getControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createResultsContextMenu();
        this.resultList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.resultList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createResultsContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.resultList.getControl());
        this.resultList.getControl().setMenu(menu);
    }

    private void fillResultsContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.resultList.getStructuredSelection();
        if (selection.size() == 1 && ((ReportResult)selection.getFirstElement()).isSuccess()) {
            manager.add((IAction)this.actionRenderPDF);
            manager.add((IAction)this.actionRenderXLSX);
            manager.add((IAction)this.actionViewResult);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.actionDeleteResult);
    }

    private void createParamEntryFields(Composite parent) {
        ReportFieldEditor editor;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        layout.horizontalSpacing = 20;
        parent.setLayout((Layout)layout);
        this.parameters = this.report.getParameters();
        if (this.parameters.isEmpty()) {
            Label label = new Label(parent, 0);
            label.setText("This report does not have parameters");
            return;
        }
        ArrayList<ReportFieldEditorFactory> fieldEditorFactories = new ArrayList<ReportFieldEditorFactory>(4);
        ServiceLoader<ReportFieldEditorFactory> loader = ServiceLoader.load(ReportFieldEditorFactory.class, this.getClass().getClassLoader());
        for (ReportFieldEditorFactory f : loader) {
            fieldEditorFactories.add(f);
        }
        Collections.sort(fieldEditorFactories, (f1, f2) -> f2.getPriority() - f1.getPriority());
        HashMap<String, ReportFieldEditor> editors = new HashMap<String, ReportFieldEditor>();
        int consumedColumns = 0;
        Label separator = null;
        for (ReportParameter parameter : this.parameters) {
            ReportFieldEditorFactory f;
            editor = null;
            Iterator iterator = fieldEditorFactories.iterator();
            while (iterator.hasNext() && (editor = (f = (ReportFieldEditorFactory)iterator.next()).editorForType(parent, parameter)) == null) {
            }
            if (editor == null) {
                editor = new StringFieldEditor(parameter, parent);
            }
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 128;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = false;
            gd.horizontalSpan = parameter.getSpan();
            editor.setLayoutData((Object)gd);
            if (layout.numColumns < parameter.getSpan()) {
                layout.numColumns = parameter.getSpan();
            }
            editors.put(parameter.getName(), editor);
            this.fields.add(editor);
            if ((consumedColumns += parameter.getSpan()) < layout.numColumns) continue;
            separator = new Label(parent, 258);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, layout.numColumns, 1));
            consumedColumns = 0;
        }
        if (separator != null && consumedColumns == 0) {
            separator.dispose();
        }
        for (ReportParameter parameter : this.parameters) {
            editor = (ReportFieldEditor)editors.get(parameter.getName());
            ReportFieldEditor parentEditor = (ReportFieldEditor)editors.get(parameter.getDependsOn());
            if (editor == null || parentEditor == null) continue;
            parentEditor.setDependantEditor(editor);
        }
    }

    private void renderSelectedResult(ReportRenderFormat format, boolean preview) {
        IStructuredSelection selection = this.resultList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ReportResult r = (ReportResult)selection.getFirstElement();
        new ReportRenderingHelper(this.view, this.report, r.getJobId(), r.getExecutionTime(), format, preview).renderReport();
    }

    public void executeReport() {
        ReportingJobConfiguration jobConfiguration = new ReportingJobConfiguration(this.report.getId());
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                jobConfiguration.executionParameters.put(((ReportParameter)this.parameters.get(i)).getName(), ((ReportFieldEditor)this.fields.get(i)).getValue());
            }
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void refreshResultList() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void refreshScheduleList() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteResults() {
        IStructuredSelection selection = this.resultList.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getShell(), (String)this.i18n.tr("Delete Report Results"), (String)this.i18n.tr("Do you really want to delete selected results?"))) {
            return;
        }
        ArrayList<UUID> resultIdList = new ArrayList<UUID>(selection.size());
        for (Object o : selection.toList()) {
            resultIdList.add(((ReportResult)o).getJobId());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void scheduleExecution() {
        ReportingJob job = new ReportingJob(this.report);
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                job.setExecutionParameter(((ReportParameter)this.parameters.get(i)).getName(), ((ReportFieldEditor)this.fields.get(i)).getValue());
            }
        }
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new General(job)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("notifications", (IPreferencePage)new Notifications(job)));
        21 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteSchedules() {
        IStructuredSelection selection = this.scheduleList.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getShell(), (String)this.i18n.tr("Delete Schedules"), (String)this.i18n.tr("Do you really want to delete selected schedules?"))) {
            return;
        }
        long[] taskIdList = new long[selection.size()];
        int i = 0;
        for (Object o : selection.toList()) {
            taskIdList[i++] = ((ReportingJob)o).getTask().getId();
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

