/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets.helpers;

import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.UnknownObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.objects.ObjectIcons;
import org.netxms.nxmc.resources.SharedIcons;

public class BaseObjectLabelProvider
extends LabelProvider {
    private ObjectIcons icons = (ObjectIcons)Registry.getSingleton(ObjectIcons.class);
    private boolean showFullPath;
    private Consumer<AbstractObject> imageUpdateCallback;

    public BaseObjectLabelProvider() {
        this(null, false);
    }

    public BaseObjectLabelProvider(Consumer<AbstractObject> imageUpdateCallback) {
        this(imageUpdateCallback, false);
    }

    public BaseObjectLabelProvider(boolean showFullPath) {
        this(null, showFullPath);
    }

    public BaseObjectLabelProvider(Consumer<AbstractObject> imageUpdateCallback, boolean showFullPath) {
        this.showFullPath = showFullPath;
        this.imageUpdateCallback = imageUpdateCallback;
    }

    public Image getImage(Object element) {
        Image icon;
        if (element instanceof UnknownObject) {
            return SharedIcons.IMG_UNKNOWN_OBJECT;
        }
        UUID iconId = ((AbstractObject)element).getIcon();
        if (iconId != null && (icon = ImageProvider.getInstance().getObjectIcon(iconId, this.imageUpdateCallback != null ? () -> this.imageUpdateCallback.accept((AbstractObject)element) : null)) != null) {
            return icon;
        }
        return this.icons.getImage(((AbstractObject)element).getObjectClass());
    }

    public String getText(Object element) {
        if (this.showFullPath) {
            return ((AbstractObject)element).getObjectNameWithPath();
        }
        return ((AbstractObject)element).getNameWithAlias();
    }

    public Consumer<AbstractObject> getImageUpdateCallback() {
        return this.imageUpdateCallback;
    }

    public void setImageUpdateCallback(Consumer<AbstractObject> imageUpdateCallback) {
        this.imageUpdateCallback = imageUpdateCallback;
    }
}

