/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.AbstractHardwareInventoryWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.ComponentTreeContentProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.ComponentTreeLabelProvider;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EntityMibTreeViewer
extends AbstractHardwareInventoryWidget {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_CLASS = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int COLUMN_MODEL = 3;
    public static final int COLUMN_FIRMWARE = 4;
    public static final int COLUMN_SERIAL = 5;
    public static final int COLUMN_VENDOR = 6;
    public static final int COLUMN_INTERFACE = 7;
    private final I18n i18n = LocalizationHelper.getI18n(EntityMibTreeViewer.class);
    private SortableTreeViewer viewer = new SortableTreeViewer((Composite)this, 65538);
    private ComponentTreeLabelProvider labelProvider;

    public EntityMibTreeViewer(Composite parent, int style, ObjectView view) {
        super(parent, style, view);
        this.addColumn(this.i18n.tr("Name"), 200);
        this.addColumn(this.i18n.tr("Class"), 100);
        this.addColumn(this.i18n.tr("Description"), 250);
        this.addColumn(this.i18n.tr("Model"), 150);
        this.addColumn(this.i18n.tr("Firmware"), 100);
        this.addColumn(this.i18n.tr("Serial Number"), 150);
        this.addColumn(this.i18n.tr("Vendor"), 150);
        this.addColumn(this.i18n.tr("Interface"), 150);
        this.labelProvider = new ComponentTreeLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ComponentTreeContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
    }

    private void addColumn(String name, int width) {
        TreeViewerColumn tc = new TreeViewerColumn((TreeViewer)this.viewer, 16384);
        tc.getColumn().setText(name);
        tc.getColumn().setWidth(width);
    }

    public void refresh() {
        long objectId = this.view.getObjectId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public void copySelectionToClipboard(int column) {
        TreeItem[] selection = this.viewer.getTree().getSelection();
        if (selection.length > 0) {
            String newLine = SystemUtils.IS_OS_WINDOWS ? "\n" : "\n";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    sb.append(selection[i].getText(0));
                    for (int j = 1; j < this.viewer.getTree().getColumnCount(); ++j) {
                        sb.append("\t");
                        sb.append(selection[i].getText(j));
                    }
                    continue;
                }
                sb.append(selection[i].getText(column));
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    public int getNameColumnIndex() {
        return 0;
    }

    public int getDescriptionColumnIndex() {
        return 2;
    }

    public int getModelColumnIndex() {
        return 3;
    }

    public int getSerialColumnIndex() {
        return 5;
    }
}

