/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Rack;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.RackWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.ElementSelectionListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.WidgetHelper;

public class RackView
extends ObjectView
implements ISelectionProvider {
    private ScrolledComposite scroller;
    private Composite content;
    private RackWidget rackFrontWidget;
    private RackWidget rackRearWidget;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet();

    public RackView() {
        super(LocalizationHelper.getI18n(RackView.class).tr("Rack"), ResourceManager.getImageDescriptor((String)"icons/object-views/rack.gif"), "objects.rack", false);
    }

    protected RackView(String subId) {
        super(LocalizationHelper.getI18n(RackView.class).tr("Rack"), ResourceManager.getImageDescriptor((String)"icons/object-views/rack.gif"), "objects.rack." + subId, false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Rack;
    }

    public int getPriority() {
        return 1;
    }

    protected void createContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 768);
        this.content = new /* Unavailable Anonymous Inner Class!! */;
        this.content.setBackground(ThemeEngine.getBackgroundColor((String)"Rack"));
        this.content.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.scroller.setContent((Control)this.content);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateRackWidgetsSize() {
        Point scrollerSize = this.scroller.getSize();
        if (this.rackRearWidget != null) {
            Point size = this.rackFrontWidget.computeSize(scrollerSize.x / 2, scrollerSize.y, true);
            this.rackFrontWidget.setSize(size);
            this.rackRearWidget.setSize(size);
            this.rackRearWidget.setLocation(size.x, 0);
        } else {
            this.rackFrontWidget.setSize(this.rackFrontWidget.computeSize(scrollerSize.x, scrollerSize.y, true));
        }
    }

    private void createPopupMenu() {
        ObjectContextMenuManager menuMgr = new ObjectContextMenuManager((View)this, (ISelectionProvider)this, null);
        this.rackFrontWidget.setMenu(menuMgr.createContextMenu((Control)this.rackFrontWidget));
        if (this.rackRearWidget != null) {
            this.rackRearWidget.setMenu(menuMgr.createContextMenu((Control)this.rackRearWidget));
        }
    }

    protected void onObjectChange(AbstractObject object) {
        this.buildRackView((Rack)object);
    }

    protected void buildRackView(Rack rack) {
        if (this.rackFrontWidget != null) {
            this.rackFrontWidget.dispose();
            this.rackFrontWidget = null;
        }
        if (this.rackRearWidget != null) {
            this.rackRearWidget.dispose();
            this.rackRearWidget = null;
        }
        if (rack != null) {
            ElementSelectionListener listener = object -> {
                this.selection = object != null ? new StructuredSelection(object) : new StructuredSelection();
                for (ISelectionChangedListener l : this.selectionListeners) {
                    l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.selection));
                }
            };
            this.rackFrontWidget = new RackWidget(this.content, 0, rack, RackOrientation.FRONT, (View)this);
            this.rackFrontWidget.addSelectionListener(listener);
            if (!rack.isFrontSideOnly()) {
                this.rackRearWidget = new RackWidget(this.content, 0, rack, RackOrientation.REAR, (View)this);
                this.rackRearWidget.addSelectionListener(listener);
            }
            Point scrollerSize = this.scroller.getSize();
            this.scroller.setMinSize(this.content.computeSize(scrollerSize.x, scrollerSize.y));
            this.updateRackWidgetsSize();
            this.createPopupMenu();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

