/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BaseBusinessService;
import org.netxms.client.objects.Circuit;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DashboardTemplate;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.interfaces.AutoBindObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.xnap.commons.i18n.I18n;

public class AutoBind
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(AutoBind.class);
    private AutoBindObject autoBindObject;
    private Button checkboxEnableBind;
    private Button checkboxEnableUnbind;
    private ScriptEditor filterSource;
    private boolean initialBind;
    private boolean initialUnbind;
    private String initialAutoBindFilter;

    public AutoBind(AbstractObject object) {
        super(LocalizationHelper.getI18n(AutoBind.class).tr("Automatic Bind Rules"), object);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.autoBindObject = (AutoBindObject)this.object;
        if (this.autoBindObject == null) {
            return dialogArea;
        }
        this.initialBind = this.autoBindObject.isAutoBindEnabled();
        this.initialUnbind = this.autoBindObject.isAutoUnbindEnabled();
        this.initialAutoBindFilter = this.autoBindObject.getAutoBindFilter();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableBind = new Button(dialogArea, 32);
        if (this.autoBindObject instanceof Cluster) {
            this.checkboxEnableBind.setText(this.i18n.tr("Automatically add nodes selected by filter to this cluster"));
        } else if (this.autoBindObject instanceof Circuit) {
            this.checkboxEnableBind.setText(this.i18n.tr("Automatically add interfaces selected by filter to this circuit"));
        } else if (this.autoBindObject instanceof Container || this.autoBindObject instanceof Collector) {
            this.checkboxEnableBind.setText(this.i18n.tr("Automatically bind objects selected by filter to this container"));
        } else if (this.autoBindObject instanceof Dashboard) {
            this.checkboxEnableBind.setText(this.i18n.tr("Automatically add this dashboard to objects selected by filter"));
        } else if (this.autoBindObject instanceof DashboardTemplate) {
            this.checkboxEnableBind.setText(this.i18n.tr("Automatically create instance dashboard for objects selected by filter"));
        } else if (this.autoBindObject instanceof NetworkMap) {
            this.checkboxEnableBind.setText(this.i18n.tr("Automatically add this network map to objects selected by filter"));
        }
        this.checkboxEnableBind.setSelection(this.autoBindObject.isAutoBindEnabled());
        this.checkboxEnableBind.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkboxEnableUnbind = new Button(dialogArea, 32);
        if (this.autoBindObject instanceof Cluster) {
            this.checkboxEnableUnbind.setText(this.i18n.tr("Automatically remove nodes from this cluster when they no longer passes filter"));
        } else if (this.autoBindObject instanceof Circuit) {
            this.checkboxEnableUnbind.setText(this.i18n.tr("Automatically remove interfaces from this circuit when they no longer passes filter"));
        } else if (this.autoBindObject instanceof Container || this.autoBindObject instanceof Collector) {
            this.checkboxEnableUnbind.setText(this.i18n.tr("Automatically unbind objects from this container when they no longer passes filter"));
        } else if (this.autoBindObject instanceof Dashboard) {
            this.checkboxEnableUnbind.setText(this.i18n.tr("Automatically remove this dashboard from objects when they no longer passes filter"));
        } else if (this.autoBindObject instanceof DashboardTemplate) {
            this.checkboxEnableUnbind.setText(this.i18n.tr("Automatically delete instance dashboard when object no longer passes filter"));
        } else if (this.autoBindObject instanceof NetworkMap) {
            this.checkboxEnableUnbind.setText(this.i18n.tr("Automatically remove this network map from objects when they no longer passes filter"));
        }
        this.checkboxEnableUnbind.setSelection(this.autoBindObject.isAutoUnbindEnabled());
        this.checkboxEnableUnbind.setEnabled(this.autoBindObject.isAutoBindEnabled());
        Label label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Filtering script"));
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        String hints = this.autoBindObject instanceof Cluster ? this.i18n.tr("Variables:\n\t$node\tnode being tested (null if object is not a node).\n\t$object\tobject being tested.\n\t$cluster\tthis cluster object.\n\nReturn value: true to add node to this cluster, false to remove, null to make no changes.") : (this.autoBindObject instanceof Container || this.autoBindObject instanceof Collector ? this.i18n.tr("Variables:\n\t$node\tnode being tested (null if object is not a node).\n\t$object\tobject being tested.\n\t$container\tthis container object.\n\nReturn value: true to bind node to this container, false to unbind, null to make no changes.") : (this.autoBindObject instanceof Circuit ? this.i18n.tr("Variables:\n\t$object\tinterface being tested.\n\t$container\tthis container object.\n\nReturn value: true to bind interface to this container, false to unbind, null to make no changes.") : (this.autoBindObject instanceof Dashboard ? this.i18n.tr("Variables:\n\t$node\tnode being tested (null if object is not a node).\n\t$object\tobject being tested.\n\t$dashboard\tthis dashboard object.\n\nReturn value: true to add this dashboard to an object, false to remove, null to make no changes.") : (this.autoBindObject instanceof DashboardTemplate ? this.i18n.tr("Variables:\n\t$node\tnode being tested (null if object is not a node).\n\t$object\tobject being tested.\n\t$template\tthis dashboard template object.\n\nReturn value: true to create dashboard instance for this object, false to delete, null to make no changes.") : (this.autoBindObject instanceof NetworkMap ? this.i18n.tr("Variables:\n\t$node\tnode being tested (null if object is not a node).\n\t$object\tobject being tested.\n\t$map\tthis network map object.\n\nReturn value: true to add this network map to an object, false to remove, null to make no changes.") : "")))));
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, hints);
        this.filterSource.setText(this.autoBindObject.getAutoBindFilter());
        this.filterSource.setEnabled(this.autoBindObject.isAutoBindEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        boolean apply = this.checkboxEnableBind.getSelection();
        boolean remove = this.checkboxEnableUnbind.getSelection();
        if (apply == this.initialBind && remove == this.initialUnbind && this.initialAutoBindFilter.equals(this.filterSource.getText())) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        NXCObjectModificationData md = new NXCObjectModificationData(((GenericObject)this.autoBindObject).getObjectId());
        md.setAutoBindFilter(this.filterSource.getText());
        int flags = this.autoBindObject.getAutoBindFlags();
        flags = apply ? flags | 1 : flags & 0xFFFFFFFE;
        flags = remove ? flags | 2 : flags & 0xFFFFFFFD;
        md.setAutoBindFlags(Integer.valueOf(flags));
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    public String getId() {
        return "autoBind";
    }

    public boolean isVisible() {
        return this.object instanceof AutoBindObject && !(this.object instanceof BaseBusinessService) && (!(this.object instanceof Dashboard) || !((Dashboard)this.object).isTemplateInstance());
    }
}

