/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.DateTimeSelector;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class DecommissionNodeDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(DecommissionNodeDialog.class);
    private int defaultExpirationDays;
    private Date expirationTime;
    private boolean clearIpAddresses;
    private DateTimeSelector expirationTimeSelector;
    private Button checkClearIpAddresses;

    public DecommissionNodeDialog(Shell parentShell, int defaultExpirationDays) {
        super(parentShell);
        this.defaultExpirationDays = defaultExpirationDays;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Decommission Node"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Label labelExpirationTime = new Label(dialogArea, 0);
        labelExpirationTime.setText(this.i18n.tr("Expiration time"));
        this.expirationTimeSelector = new DateTimeSelector(dialogArea, 0);
        Date defaultExpiration = new Date(System.currentTimeMillis() + (long)this.defaultExpirationDays * 24L * 60L * 60L * 1000L);
        this.expirationTimeSelector.setValue(defaultExpiration);
        this.expirationTimeSelector.setToolTipText(this.i18n.tr("Node will be automatically deleted after this time"));
        this.checkClearIpAddresses = new Button(dialogArea, 32);
        this.checkClearIpAddresses.setText(this.i18n.tr("Clear IP addresses from node and interfaces"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkClearIpAddresses.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.expirationTime = this.expirationTimeSelector.getValue();
        this.clearIpAddresses = this.checkClearIpAddresses.getSelection();
        if (this.expirationTime.before(new Date())) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Expiration time must be in the future!"));
            return;
        }
        super.okPressed();
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isClearIpAddresses() {
        return this.clearIpAddresses;
    }
}

