/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.netxms.client.maps.NetworkMapLink;

public class MultiConnectionAnchor
extends ChopboxAnchor {
    private NetworkMapLink link;

    public MultiConnectionAnchor(IFigure owner, NetworkMapLink link) {
        super(owner);
        this.link = link;
    }

    public Point getLocation(Point reference) {
        Rectangle r = Rectangle.getSINGLETON();
        r.setBounds(this.getBox());
        this.getOwner().translateToAbsolute((Translatable)r);
        double centerX = r.getCenter().preciseX();
        double centerY = r.getCenter().preciseY();
        if (r.isEmpty() || reference.x == (int)centerX && reference.y == (int)centerY) {
            return new Point((int)centerX, (int)centerY);
        }
        double dx = reference.preciseX() - centerX;
        double dy = reference.preciseY() - centerY;
        double scale = 0.5 / Math.max(Math.abs(dx) / (double)r.width, Math.abs(dy) / (double)r.height);
        dx *= scale;
        dy *= scale;
        double adj = Math.abs(reference.preciseX() - centerX);
        double opp = Math.abs(reference.preciseY() - centerY);
        double theta = Math.atan(opp / adj);
        double xOffset = centerX;
        double yOffset = centerY;
        if (this.link.getDuplicateCount() > 0) {
            float maxWidth = (float)Math.min(r.height, r.width) * 1.3f;
            float maxWidthBetweenLinks = (float)Math.min(r.height, r.width) * 0.35f;
            float pixelsPerLink = Math.min(maxWidthBetweenLinks, (float)Math.round(maxWidth / (float)this.link.getDuplicateCount()));
            float shift = pixelsPerLink * (float)this.link.getDuplicateCount() / 2.0f * -1.0f + (float)this.link.getPosition() * pixelsPerLink;
            if (centerX < reference.preciseX() && centerY < reference.preciseY() || centerX > reference.preciseX() && centerY > reference.preciseY()) {
                xOffset = centerX + (double)shift * Math.sin(-theta);
                yOffset = centerY + (double)shift * Math.cos(-theta);
            } else {
                xOffset = centerX + (double)shift * Math.sin(theta);
                yOffset = centerY + (double)shift * Math.cos(theta);
            }
        }
        centerX = dx + xOffset;
        centerY = dy + yOffset;
        return new Point((double)Math.round(centerX), (double)Math.round(centerY));
    }
}

