/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.propertypages.RuleBasePropertyPage;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.xnap.commons.i18n.I18n;

public class RuleIncident
extends RuleBasePropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(RuleIncident.class);
    private Button checkCreateIncident;
    private Button checkAIAnalysis;
    private Composite incidentOptionsGroup;
    private LabeledSpinner incidentDelay;
    private LabeledText incidentTitle;
    private LabeledText incidentDescription;
    private Composite incidentAIAnalysisGroup;
    private LabeledCombo incidentAIAnalysysDepth;
    private Button incidentAIAutoAssign;
    private LabeledText insidentAIPrompt;

    public RuleIncident(RuleEditor editor) {
        super(editor, LocalizationHelper.getI18n(RuleIncident.class).tr("Incident"));
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        dialogArea.setLayout((Layout)layout);
        this.checkCreateIncident = new Button(dialogArea, 32);
        this.checkCreateIncident.setText(this.i18n.tr("Create incident on alarm creation"));
        this.checkCreateIncident.setSelection((this.rule.getFlags() & 0x80000) != 0);
        this.checkCreateIncident.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkAIAnalysis = new Button(dialogArea, 32);
        this.checkAIAnalysis.setText(this.i18n.tr("Perform AI-based incident analysis"));
        this.checkAIAnalysis.setSelection((this.rule.getFlags() & 0x100000) != 0);
        this.checkAIAnalysis.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.incidentOptionsGroup = new Composite(dialogArea, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.exclude = (this.rule.getFlags() & 0x80000) == 0;
        this.incidentOptionsGroup.setLayoutData((Object)gd);
        this.incidentOptionsGroup.setVisible((this.rule.getFlags() & 0x80000) != 0);
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.incidentOptionsGroup.setLayout((Layout)layout);
        this.incidentDelay = new LabeledSpinner(this.incidentOptionsGroup, 0);
        this.incidentDelay.setLabel(this.i18n.tr("Creation delay (seconds, 0 for immediate)"));
        this.incidentDelay.setRange(0, 99999);
        this.incidentDelay.setSelection(this.rule.getIncidentDelay());
        this.incidentTitle = new LabeledText(this.incidentOptionsGroup, 0);
        this.incidentTitle.setLabel(this.i18n.tr("Title (leave empty to use alarm message)"));
        this.incidentTitle.setText(this.rule.getIncidentTitle());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.incidentTitle.setLayoutData((Object)gd);
        this.incidentDescription = new LabeledText(this.incidentOptionsGroup, 0, 2562);
        this.incidentDescription.setLabel(this.i18n.tr("Description"));
        this.incidentDescription.setText(this.rule.getIncidentDescription());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 100;
        this.incidentDescription.setLayoutData((Object)gd);
        this.incidentAIAnalysisGroup = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.exclude = (this.rule.getFlags() & 0x80000) == 0;
        this.incidentAIAnalysisGroup.setLayoutData((Object)gd);
        this.incidentAIAnalysisGroup.setVisible((this.rule.getFlags() & 0x180000) == 0x180000);
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.incidentAIAnalysisGroup.setLayout((Layout)layout);
        this.incidentAIAnalysysDepth = new LabeledCombo(this.incidentAIAnalysisGroup, 0);
        this.incidentAIAnalysysDepth.setLabel(this.i18n.tr("AI Analysis Depth"));
        this.incidentAIAnalysysDepth.add(this.i18n.tr("Quick"));
        this.incidentAIAnalysysDepth.add(this.i18n.tr("Standard"));
        this.incidentAIAnalysysDepth.add(this.i18n.tr("Deep"));
        this.incidentAIAnalysysDepth.select(this.rule.getIncidentAIAnalysisDepth());
        this.incidentAIAutoAssign = new Button(this.incidentAIAnalysisGroup, 32);
        this.incidentAIAutoAssign.setText(this.i18n.tr("Automatically assign incident to suggested owner"));
        this.incidentAIAutoAssign.setSelection((this.rule.getFlags() & 0x200000) != 0);
        this.insidentAIPrompt = new LabeledText(this.incidentAIAnalysisGroup, 0, 2562);
        this.insidentAIPrompt.setLabel(this.i18n.tr("AI Prompt for Analysis (optional)"));
        this.insidentAIPrompt.setText(this.rule.getIncidentAIPrompt());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 100;
        this.insidentAIPrompt.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.checkCreateIncident.getSelection()) {
            this.rule.setIncidentDelay(this.incidentDelay.getSelection());
            this.rule.setIncidentTitle(this.incidentTitle.getText().trim());
            this.rule.setIncidentDescription(this.incidentDescription.getText());
            this.rule.setFlags(this.rule.getFlags() | 0x80000);
            if (this.checkAIAnalysis.getSelection()) {
                this.rule.setIncidentAIAnalysisDepth(this.incidentAIAnalysysDepth.getSelectionIndex());
                this.rule.setIncidentAIPrompt(this.insidentAIPrompt.getText());
                if (this.incidentAIAutoAssign.getSelection()) {
                    this.rule.setFlags(this.rule.getFlags() | 0x100000 | 0x200000);
                } else {
                    this.rule.setFlags(this.rule.getFlags() & 0xFFDFFFFF | 0x100000);
                }
            } else {
                this.rule.setFlags(this.rule.getFlags() & 0xFFCFFFFF);
            }
        } else {
            this.rule.setFlags(this.rule.getFlags() & 0xFFF7FFFF);
        }
        this.editor.setModified(true);
        return true;
    }
}

