/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.Severity;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.widgets.AlarmCategorySelector;
import org.netxms.nxmc.modules.events.propertypages.RuleBasePropertyPage;
import org.netxms.nxmc.modules.events.widgets.EventSelector;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptSelector;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class RuleAlarm
extends RuleBasePropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(RuleAlarm.class);
    private static final int ALARM_NO_ACTION = 0;
    private static final int ALARM_CREATE = 1;
    private static final int ALARM_RESOLVE = 2;
    private static final int ALARM_TERMINATE = 3;
    private int alarmAction;
    private Composite dialogArea;
    private Button alarmNoAction;
    private Button alarmCreate;
    private Button alarmResolve;
    private Button alarmTerminate;
    private Composite alarmCreationGroup;
    private Composite alarmTerminationGroup;
    private LabeledText alarmMessage;
    private LabeledText alarmKeyCreate;
    private Combo alarmSeverity;
    private LabeledText alarmTimeout;
    private AlarmCategorySelector alarmCategory;
    private EventSelector timeoutEvent;
    private ScriptSelector rcaScript;
    private LabeledText alarmKeyTerminate;
    private Button checkTerminateWithRegexp;
    private Button checkCreateHelpdeskTicket;
    private Button checkRequestAiComment;

    public RuleAlarm(RuleEditor editor) {
        super(editor, LocalizationHelper.getI18n(RuleAlarm.class).tr("Alarm"));
    }

    protected Control createContents(Composite parent) {
        this.alarmAction = this.calculateAlarmAction();
        this.dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        this.dialogArea.setLayout((Layout)layout);
        Composite radioGroup = new Composite(this.dialogArea, 0);
        RowLayout rbLayout = new RowLayout(512);
        rbLayout.marginBottom = 0;
        rbLayout.marginTop = 0;
        rbLayout.marginLeft = 0;
        rbLayout.marginRight = 0;
        radioGroup.setLayout((Layout)rbLayout);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        radioGroup.setLayoutData((Object)gd);
        this.alarmNoAction = new Button(radioGroup, 16);
        this.alarmNoAction.setText(this.i18n.tr("Do not change alarms"));
        this.alarmNoAction.setSelection(this.alarmAction == 0);
        this.alarmNoAction.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.alarmCreate = new Button(radioGroup, 16);
        this.alarmCreate.setText(this.i18n.tr("Create new alarm"));
        this.alarmCreate.setSelection(this.alarmAction == 1);
        this.alarmCreate.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.alarmResolve = new Button(radioGroup, 16);
        this.alarmResolve.setText(this.i18n.tr("Resolve alarms"));
        this.alarmResolve.setSelection(this.alarmAction == 2);
        this.alarmResolve.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.alarmTerminate = new Button(radioGroup, 16);
        this.alarmTerminate.setText(this.i18n.tr("Terminate alarms"));
        this.alarmTerminate.setSelection(this.alarmAction == 3);
        this.alarmTerminate.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.alarmCreationGroup = new Composite(this.dialogArea, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.exclude = this.alarmAction != 1;
        this.alarmCreationGroup.setLayoutData((Object)gd);
        this.alarmCreationGroup.setVisible(this.alarmAction == 1);
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.alarmCreationGroup.setLayout((Layout)layout);
        this.alarmMessage = new LabeledText(this.alarmCreationGroup, 0);
        this.alarmMessage.setLabel(this.i18n.tr("Message"));
        this.alarmMessage.setText(this.rule.getAlarmMessage());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.alarmMessage.setLayoutData((Object)gd);
        this.alarmKeyCreate = new LabeledText(this.alarmCreationGroup, 0);
        this.alarmKeyCreate.setLabel(this.i18n.tr("Alarm key"));
        this.alarmKeyCreate.setText(this.rule.getAlarmKey());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.alarmKeyCreate.setLayoutData((Object)gd);
        Composite alarmCreationSubgroup = new Composite(this.alarmCreationGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        alarmCreationSubgroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        alarmCreationSubgroup.setLayoutData((Object)gd);
        Composite severityGroup = new Composite(alarmCreationSubgroup, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        severityGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        severityGroup.setLayoutData((Object)gd);
        new Label(severityGroup, 0).setText(this.i18n.tr("Alarm severity"));
        this.alarmSeverity = new Combo(severityGroup, 2060);
        for (int i = 0; i < Severity.UNKNOWN.getValue(); ++i) {
            this.alarmSeverity.add(StatusDisplayInfo.getStatusText((int)i));
        }
        this.alarmSeverity.add(this.i18n.tr("From event"));
        this.alarmSeverity.select(this.rule.getAlarmSeverity().getValue());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.alarmSeverity.setLayoutData((Object)gd);
        this.alarmTimeout = new LabeledText(alarmCreationSubgroup, 0);
        this.alarmTimeout.setLabel(this.i18n.tr("Alarm timeout"));
        this.alarmTimeout.getTextControl().setTextLimit(5);
        this.alarmTimeout.setText(Integer.toString(this.rule.getAlarmTimeout()));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.alarmTimeout.setLayoutData((Object)gd);
        this.timeoutEvent = new EventSelector(this.alarmCreationGroup, 0);
        this.timeoutEvent.setLabel(this.i18n.tr("Timeout event"));
        this.timeoutEvent.setEventCode(this.rule.getAlarmTimeoutEvent());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.timeoutEvent.setLayoutData((Object)gd);
        this.rcaScript = new ScriptSelector(this.alarmCreationGroup, 0, false, true);
        this.rcaScript.setLabel("Root cause analysis script");
        this.rcaScript.setScriptName(this.rule.getRcaScriptName());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.rcaScript.setLayoutData((Object)gd);
        this.alarmCategory = new AlarmCategorySelector(this.alarmCreationGroup, 0);
        this.alarmCategory.setLabel(this.i18n.tr("Alarm category"));
        this.alarmCategory.setCategoryId(this.rule.getAlarmCategories());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.alarmCategory.setLayoutData((Object)gd);
        this.checkCreateHelpdeskTicket = new Button(this.alarmCreationGroup, 32);
        this.checkCreateHelpdeskTicket.setText(this.i18n.tr("Create helpdesk ticket on alarm creation"));
        this.checkCreateHelpdeskTicket.setSelection((this.rule.getFlags() & 0x2000) != 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        this.checkCreateHelpdeskTicket.setLayoutData((Object)gd);
        this.checkRequestAiComment = new Button(this.alarmCreationGroup, 32);
        this.checkRequestAiComment.setText(this.i18n.tr("Add AI assistant's comment on alarm creation"));
        this.checkRequestAiComment.setSelection((this.rule.getFlags() & 0x40000) != 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        this.checkRequestAiComment.setLayoutData((Object)gd);
        this.alarmTerminationGroup = new Composite(this.dialogArea, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.exclude = this.alarmAction != 3 && this.alarmAction != 2;
        this.alarmTerminationGroup.setLayoutData((Object)gd);
        this.alarmTerminationGroup.setVisible(this.alarmAction == 3 || this.alarmAction == 2);
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.alarmTerminationGroup.setLayout((Layout)layout);
        this.alarmKeyTerminate = new LabeledText(this.alarmTerminationGroup, 0);
        this.alarmKeyTerminate.setLabel(this.alarmAction == 3 ? this.i18n.tr("Terminate all alarms with key") : this.i18n.tr("Resolve all alarms with key"));
        this.alarmKeyTerminate.setText(this.rule.getAlarmKey());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.alarmKeyTerminate.setLayoutData((Object)gd);
        this.checkTerminateWithRegexp = new Button(this.alarmTerminationGroup, 32);
        this.checkTerminateWithRegexp.setText(this.alarmAction == 3 ? this.i18n.tr("Use regular expression for alarm termination") : this.i18n.tr("Use regular expression for alarm resolving"));
        this.checkTerminateWithRegexp.setSelection((this.rule.getFlags() & 0x20) != 0);
        return this.dialogArea;
    }

    private int calculateAlarmAction() {
        if ((this.rule.getFlags() & 8) == 0) {
            return 0;
        }
        if (this.rule.getAlarmSeverity().compareTo((Enum)Severity.TERMINATE) < 0) {
            return 1;
        }
        if (this.rule.getAlarmSeverity() == Severity.RESOLVE) {
            return 2;
        }
        return 3;
    }

    private void changeAlarmAction(int newAction) {
        Composite group;
        if (this.alarmAction != 0) {
            group = this.alarmAction == 1 ? this.alarmCreationGroup : this.alarmTerminationGroup;
            ((GridData)group.getLayoutData()).exclude = true;
            group.setVisible(false);
        }
        this.alarmAction = newAction;
        if (this.alarmAction != 0) {
            group = this.alarmAction == 1 ? this.alarmCreationGroup : this.alarmTerminationGroup;
            ((GridData)group.getLayoutData()).exclude = false;
            group.setVisible(true);
            this.alarmKeyTerminate.setLabel(this.alarmAction == 3 ? this.i18n.tr("Terminate all alarms with key") : this.i18n.tr("Resolve all alarms with key"));
            this.checkTerminateWithRegexp.setText(this.alarmAction == 3 ? this.i18n.tr("Use regular expression for alarm termination") : this.i18n.tr("Use regular expression for alarm resolving"));
        }
        this.dialogArea.layout(true, true);
    }

    protected boolean applyChanges(boolean isApply) {
        switch (this.alarmAction) {
            case 1: {
                try {
                    int t = Integer.parseInt(this.alarmTimeout.getText());
                    if (t < 0) {
                        MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid timeout value (must be 0 or positive integer)"));
                        return false;
                    }
                    this.rule.setAlarmTimeout(t);
                }
                catch (NumberFormatException e) {
                    MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid timeout value (must be 0 or positive integer)"));
                    return false;
                }
                this.rule.setAlarmMessage(this.alarmMessage.getText());
                this.rule.setAlarmKey(this.alarmKeyCreate.getText());
                this.rule.setAlarmSeverity(Severity.getByValue((int)this.alarmSeverity.getSelectionIndex()));
                this.rule.setAlarmTimeoutEvent(this.timeoutEvent.getEventCode());
                this.rule.setAlarmCategories(this.alarmCategory.getCategoryId());
                this.rule.setRcaScriptName(this.rcaScript.getScriptName());
                this.rule.setFlags(this.rule.getFlags() | 8);
                if (this.checkCreateHelpdeskTicket.getSelection()) {
                    this.rule.setFlags(this.rule.getFlags() | 0x2000);
                } else {
                    this.rule.setFlags(this.rule.getFlags() & 0xFFFFDFFF);
                }
                if (this.checkRequestAiComment.getSelection()) {
                    this.rule.setFlags(this.rule.getFlags() | 0x40000);
                    break;
                }
                this.rule.setFlags(this.rule.getFlags() & 0xFFFBFFFF);
                break;
            }
            case 2: 
            case 3: {
                this.rule.setAlarmKey(this.alarmKeyTerminate.getText());
                this.rule.setAlarmSeverity(this.alarmAction == 3 ? Severity.TERMINATE : Severity.RESOLVE);
                this.rule.setFlags(this.rule.getFlags() | 8);
                if (this.checkTerminateWithRegexp.getSelection()) {
                    this.rule.setFlags(this.rule.getFlags() | 0x20);
                } else {
                    this.rule.setFlags(this.rule.getFlags() & 0xFFFFFFDF);
                }
                this.rule.setFlags(this.rule.getFlags() & 0xFFFFDFFF);
                break;
            }
            default: {
                this.rule.setFlags(this.rule.getFlags() & 0xFFFFDFF7);
            }
        }
        this.editor.setModified(true);
        return true;
    }
}

