/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.dialogs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.MultiEventSelectionDialog;
import org.xnap.commons.i18n.I18n;

public class MultiEventSelectionDialog
extends Dialog {
    private static final String CONFIG_PREFIX = "MultiEventSelectionDialog";
    private final I18n i18n = LocalizationHelper.getI18n(MultiEventSelectionDialog.class);
    private NXCSession session;
    private FilterText filterTextWidget;
    private CheckboxTableViewer viewer;
    private List<SelectableEvent> events = new ArrayList();
    private Set<Integer> initialSelection;
    private int[] selectedEventCodes;
    private String filterText = "";

    public MultiEventSelectionDialog(Shell parentShell, int[] initialSelection) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.session = Registry.getSession();
        this.initialSelection = new HashSet();
        if (initialSelection != null) {
            for (int code : initialSelection) {
                this.initialSelection.add(code);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Select Events"));
        PreferenceStore settings = PreferenceStore.getInstance();
        int cx = settings.getAsInteger("MultiEventSelectionDialog.cx", 0);
        int cy = settings.getAsInteger("MultiEventSelectionDialog.cy", 0);
        if (cx > 0 && cy > 0) {
            newShell.setSize(cx, cy);
        } else {
            newShell.setSize(600, 500);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.filterTextWidget = new FilterText(dialogArea, 0, null, false, false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.filterTextWidget.setLayoutData((Object)gd);
        this.filterTextWidget.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)dialogArea, (int)68352);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        TableColumn colCode = new TableColumn(this.viewer.getTable(), 16384);
        colCode.setText(this.i18n.tr("Code"));
        colCode.setWidth(100);
        TableColumn colName = new TableColumn(this.viewer.getTable(), 16384);
        colName.setText(this.i18n.tr("Name"));
        colName.setWidth(250);
        TableColumn colTags = new TableColumn(this.viewer.getTable(), 16384);
        colTags.setText(this.i18n.tr("Tags"));
        colTags.setWidth(200);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SelectableEventLabelProvider());
        this.viewer.setCheckStateProvider((ICheckStateProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addFilter((ViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addCheckStateListener((ICheckStateListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener(event -> {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selection != null) {
                boolean currentState = ((SelectableEvent)selection).selected;
                ((SelectableEvent)selection).selected = !currentState;
                this.viewer.setChecked(selection, !currentState);
                this.viewer.update(selection, null);
            }
        });
        this.viewer.getTable().addDisposeListener((DisposeListener & Serializable)e -> this.saveSettings());
        this.loadEventTemplates();
        return dialogArea;
    }

    private void loadEventTemplates() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void packColumns() {
        Table table = this.viewer.getTable();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            TableColumn c = table.getColumn(i);
            if (!c.getResizable()) continue;
            c.pack();
        }
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("MultiEventSelectionDialog.cx", size.x);
        settings.set("MultiEventSelectionDialog.cy", size.y);
    }

    protected void okPressed() {
        ArrayList<Integer> selected = new ArrayList<Integer>();
        for (SelectableEvent se : this.events) {
            if (!se.selected) continue;
            selected.add(se.event.getCode());
        }
        this.selectedEventCodes = new int[selected.size()];
        for (int i = 0; i < selected.size(); ++i) {
            this.selectedEventCodes[i] = (Integer)selected.get(i);
        }
        super.okPressed();
    }

    public int[] getSelectedEventCodes() {
        return this.selectedEventCodes;
    }

    public EventTemplate[] getSelectedEvents() {
        ArrayList<EventTemplate> selected = new ArrayList<EventTemplate>();
        for (SelectableEvent se : this.events) {
            if (!se.selected) continue;
            selected.add(se.event);
        }
        return selected.toArray(new EventTemplate[0]);
    }
}

