/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.base.GeoLocation;
import org.netxms.base.GeoLocationFormatException;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.GeoMapConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class GeoMap
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(GeoMap.class);
    private GeoMapConfig config;
    private TitleConfigurator title;
    private LabeledText latitude;
    private LabeledText longitude;
    private Spinner zoom;
    private ObjectSelector objectSelector;

    public GeoMap(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(GeoMap.class).tr("Geo Map"), elementConfig);
    }

    public String getId() {
        return "geomap";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof GeoMapConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (GeoMapConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.title.setLayoutData((Object)gd);
        this.latitude = new LabeledText(dialogArea, 0);
        this.latitude.setLabel(this.i18n.tr("Latitude"));
        this.latitude.setText(GeoLocation.latitudeToString((double)this.config.getLatitude()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.latitude.setLayoutData((Object)gd);
        this.longitude = new LabeledText(dialogArea, 0);
        this.longitude.setLabel(this.i18n.tr("Longitude"));
        this.longitude.setText(GeoLocation.longitudeToString((double)this.config.getLongitude()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.longitude.setLayoutData((Object)gd);
        this.zoom = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)this.i18n.tr("Zoom"), (int)0, (int)18, (Object)"WidgetHelper::default_layout_data");
        this.zoom.setSelection(this.config.getZoom());
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel(this.i18n.tr("Root object"));
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getRootObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.objectSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        try {
            GeoLocation center = GeoLocation.parseGeoLocation((String)this.latitude.getText(), (String)this.longitude.getText());
            this.config.setLatitude(center.getLatitude());
            this.config.setLongitude(center.getLongitude());
        }
        catch (GeoLocationFormatException e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Please enter correct latitude and longitude value"));
        }
        this.config.setZoom(this.zoom.getSelection());
        this.config.setRootObjectId(this.objectSelector.getObjectId());
        return true;
    }
}

