/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.EventMonitorConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.events.widgets.MultiEventSelector;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class EventMonitor
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(EventMonitor.class);
    private EventMonitorConfig config;
    private ObjectSelector objectSelector;
    private MultiEventSelector eventSelector;
    private LabeledText filterText;
    private LabeledSpinner maxEvents;
    private LabeledSpinner timeRangeMinutes;
    private TitleConfigurator title;

    public EventMonitor(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(EventMonitor.class).tr("Event Monitor"), elementConfig);
    }

    public String getId() {
        return "event-monitor";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof EventMonitorConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (EventMonitorConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel(this.i18n.tr("Root object"));
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.eventSelector = new MultiEventSelector(dialogArea, 0, new SelectorConfigurator().setShowClearButton(true));
        this.eventSelector.setLabel(this.i18n.tr("Events"));
        this.eventSelector.setEventCodes(this.config.getEventCodes());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.eventSelector.setLayoutData((Object)gd);
        this.filterText = new LabeledText(dialogArea, 0);
        this.filterText.setLabel(this.i18n.tr("Text filter"));
        this.filterText.setText(this.config.getFilter());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.filterText.setLayoutData((Object)gd);
        this.maxEvents = new LabeledSpinner(dialogArea, 0);
        this.maxEvents.setLabel(this.i18n.tr("Maximum events to load (0 to disable)"));
        this.maxEvents.setRange(0, 1000);
        this.maxEvents.setSelection(this.config.getMaxEvents());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.maxEvents.setLayoutData((Object)gd);
        this.timeRangeMinutes = new LabeledSpinner(dialogArea, 0);
        this.timeRangeMinutes.setLabel(this.i18n.tr("Time range (minutes, 0 for no limit)"));
        this.timeRangeMinutes.setRange(0, 10080);
        this.timeRangeMinutes.setSelection(this.config.getTimeRangeMinutes());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.timeRangeMinutes.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setEventCodes(this.eventSelector.getEventCodes());
        this.config.setFilter(this.filterText.getText().trim());
        this.config.setMaxEvents(this.maxEvents.getSelection());
        this.config.setTimeRangeMinutes(this.timeRangeMinutes.getSelection());
        return true;
    }
}

