/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.BusinessService;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.AvailabilityChartConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class AvailabilityChart
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(AvailabilityChart.class);
    private AvailabilityChartConfig config;
    private TitleConfigurator title;
    private ObjectSelector objectSelector;
    private Combo periodSelector;
    private LabeledSpinner daysSelector;
    private Combo legendPosition;
    private Button checkShowLegend;
    private Button checkTranslucent;

    public AvailabilityChart(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(AvailabilityChart.class).tr("Availability Chart"), elementConfig);
    }

    public String getId() {
        return "availability-chart";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof AvailabilityChartConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (AvailabilityChartConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel(this.i18n.tr("Business service"));
        this.objectSelector.setClassFilter(ObjectSelectionDialog.createBusinessServiceSelectionFilter());
        this.objectSelector.setObjectClass(BusinessService.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.periodSelector = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Period"), (Object)"WidgetHelper::default_layout_data");
        this.periodSelector.add(this.i18n.tr("Today"));
        this.periodSelector.add(this.i18n.tr("Yesterday"));
        this.periodSelector.add(this.i18n.tr("This week"));
        this.periodSelector.add(this.i18n.tr("Last week"));
        this.periodSelector.add(this.i18n.tr("This month"));
        this.periodSelector.add(this.i18n.tr("Last month"));
        this.periodSelector.add(this.i18n.tr("This year"));
        this.periodSelector.add(this.i18n.tr("Last year"));
        this.periodSelector.add(this.i18n.tr("Custom"));
        this.periodSelector.select(this.config.getPeriod());
        this.periodSelector.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.legendPosition = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Legend position"), (Object)"WidgetHelper::default_layout_data");
        this.legendPosition.add(this.i18n.tr("Left"));
        this.legendPosition.add(this.i18n.tr("Right"));
        this.legendPosition.add(this.i18n.tr("Top"));
        this.legendPosition.add(this.i18n.tr("Bottom"));
        this.legendPosition.select(AvailabilityChart.positionIndexFromValue((int)this.config.getLegendPosition()));
        this.daysSelector = new LabeledSpinner(dialogArea, 0);
        this.daysSelector.setLabel("Period length (days)");
        this.daysSelector.setRange(1, 1000);
        this.daysSelector.setSelection(this.config.getNumberOfDays());
        this.daysSelector.setVisible(this.periodSelector.getSelectionIndex() == 8);
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(this.i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        this.checkShowLegend.setText(this.i18n.tr("Show &legend"));
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowLegend.setLayoutData((Object)gd);
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        this.checkTranslucent.setText(this.i18n.tr("T&ranslucent"));
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkTranslucent.setLayoutData((Object)gd);
        return dialogArea;
    }

    private static int positionIndexFromValue(int value) {
        switch (value) {
            case 8: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setPeriod(this.periodSelector.getSelectionIndex());
        this.config.setNumberOfDays(this.daysSelector.getSelection());
        this.config.setLegendPosition(1 << this.legendPosition.getSelectionIndex());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        return true;
    }
}

