/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DashboardBase;
import org.netxms.client.objects.DashboardTemplate;
import org.netxms.client.xml.XMLTools;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfigFactory;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementLayout;
import org.netxms.nxmc.modules.objects.actions.ObjectAction;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ExportDashboardAction
extends ObjectAction<DashboardBase> {
    private final I18n i18n = LocalizationHelper.getI18n(ExportDashboardAction.class);
    private static final Logger logger = LoggerFactory.getLogger(ExportDashboardAction.class);

    public ExportDashboardAction(ViewPlacement viewPlacement, ISelectionProvider selectionProvider) {
        super(DashboardBase.class, LocalizationHelper.getI18n(ExportDashboardAction.class).tr("&Export..."), viewPlacement, selectionProvider);
        this.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/export.png"));
    }

    protected void run(List<DashboardBase> selection) {
        DashboardBase dashboard = selection.get(0);
        if (dashboard instanceof Dashboard && ((Dashboard)dashboard).isTemplateInstance() && !MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("This instance of a Template Dashboard will be exported as a regular Dashboard. Continue?"))) {
            return;
        }
        HashSet objects = new HashSet();
        HashMap items = new HashMap();
        StringBuilder xml = new StringBuilder("<dashboard>\n\t<name>");
        xml.append(dashboard.getObjectName());
        xml.append("</name>\n\t<columns>");
        xml.append(dashboard.getNumColumns());
        xml.append("</columns>\n\t<flags>");
        xml.append(dashboard.getFlags());
        xml.append("</flags>\n\t<autoBindFlags>");
        xml.append(dashboard.getAutoBindFlags());
        xml.append("</autoBindFlags>\n\t<autoBindFilter>");
        xml.append(dashboard.getAutoBindFilter().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        xml.append("</autoBindFilter>\n");
        if (dashboard instanceof Dashboard) {
            xml.append("\t<isTemplate>");
            xml.append(false);
            xml.append("</isTemplate>\n\n");
        } else if (dashboard instanceof DashboardTemplate) {
            xml.append("\t<isTemplate>");
            xml.append(true);
            xml.append("</isTemplate>\n\n");
            String nameTemplate = ((DashboardTemplate)dashboard).getNameTemplate();
            xml.append("\t<nameTemplate>");
            xml.append(nameTemplate.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
            xml.append("</nameTemplate>\n\n");
        }
        xml.append("\t<elements>\n");
        for (DashboardElement e : dashboard.getElements()) {
            Gson gson = new Gson();
            DashboardElementLayout layout = (DashboardElementLayout)gson.fromJson(e.getLayout(), DashboardElementLayout.class);
            DashboardElementConfig config = DashboardElementConfigFactory.create((DashboardElement)e);
            if (config == null) continue;
            try {
                StringBuilder element = new StringBuilder();
                element.append("\t\t<dashboardElement>\n\t\t\t<type>");
                element.append(e.getType());
                element.append("</type>\n");
                element.append(XMLTools.serialize((Object)layout));
                element.append('\n');
                element.append(config.createXml());
                element.append("\n\t\t</dashboardElement>\n");
                objects.addAll(config.getObjects());
                items.putAll(config.getDataCollectionItems());
                xml.append((CharSequence)element);
            }
            catch (Exception e1) {
                logger.error("Failed to convert dashboard element", (Throwable)e1);
            }
        }
        xml.append("\t</elements>\n");
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isValidForSelection(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof DashboardBase;
    }
}

