/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.views.helpers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.client.constants.AMDataType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetAttributeListLabelProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class AssetPropertyReader {
    private static final Logger logger = LoggerFactory.getLogger(AssetPropertyReader.class);
    private I18n i18n = LocalizationHelper.getI18n(AssetPropertyReader.class);
    private NXCSession session = Registry.getSession();
    private BaseObjectLabelProvider objectLabelProvider = new BaseObjectLabelProvider();

    public Image valueToImage(String name, String value) {
        if (((AssetAttribute)this.session.getAssetManagementSchema().get(name)).getDataType() != AMDataType.OBJECT_REFERENCE) {
            return null;
        }
        long objectId = 0L;
        try {
            objectId = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.warn("Cannot parse object ID", (Throwable)e);
        }
        AbstractObject object = this.session.findObjectById(objectId);
        return object != null ? this.objectLabelProvider.getImage((Object)object) : null;
    }

    public String valueToText(String name, String value) {
        if (value == null) {
            return "";
        }
        AssetAttribute attribute = (AssetAttribute)this.session.getAssetManagementSchema().get(name);
        if (attribute.getDataType() == AMDataType.OBJECT_REFERENCE) {
            long objectId = 0L;
            try {
                objectId = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                logger.warn("Filed to parse object ID", (Throwable)e);
            }
            AbstractObject object = this.session.findObjectById(objectId);
            if (object != null) {
                return this.objectLabelProvider.getText((Object)object);
            }
        } else {
            if (attribute.getDataType() == AMDataType.ENUM) {
                String displayName = (String)attribute.getEnumValues().get(value);
                return displayName == null || displayName.isBlank() ? value : displayName;
            }
            if (attribute.getDataType() == AMDataType.DATE) {
                Calendar c = Calendar.getInstance();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                try {
                    c.setTime(dateFormat.parse(value));
                }
                catch (ParseException e) {
                    logger.error("Cannot parse date", (Throwable)e);
                    return "<Error>";
                }
                return DateFormatFactory.getDateFormat().format(c.getTime());
            }
        }
        return value;
    }

    public String getSystemType(String name) {
        return AssetAttributeListLabelProvider.SYSTEM_TYPE[((AssetAttribute)this.session.getAssetManagementSchema().get(name)).getSystemType().getValue()];
    }

    public String isUnique(String name) {
        return ((AssetAttribute)this.session.getAssetManagementSchema().get(name)).isUnique() ? this.i18n.tr("Yes") : this.i18n.tr("No");
    }

    public String isMandatory(String name) {
        return ((AssetAttribute)this.session.getAssetManagementSchema().get(name)).isMandatory() ? this.i18n.tr("Yes") : this.i18n.tr("No");
    }

    public String getDisplayName(String name) {
        return ((AssetAttribute)this.session.getAssetManagementSchema().get(name)).getEffectiveDisplayName();
    }

    public void dispose() {
        this.objectLabelProvider.dispose();
    }
}

