/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class AssetAttributeListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    final I18n i18n = LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class);
    public static final String[] DATA_TYPES = new String[]{LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("String"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("Integer"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("Number"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("Boolean"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("Enum"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("MAC address"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("IP address"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("UUID"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("Object reference"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("Date")};
    public static final String[] SYSTEM_TYPE = new String[]{LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("None"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("Serial"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("IP address"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("MAC address"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("Vendor"), LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class).tr("Model")};

    public String getColumnText(Object element, int columnIndex) {
        AssetAttribute attr = (AssetAttribute)element;
        switch (columnIndex) {
            case 2: {
                return DATA_TYPES[attr.getDataType().getValue()];
            }
            case 1: {
                return attr.getDisplayName();
            }
            case 6: {
                return attr.getAutofillScript().isEmpty() ? this.i18n.tr("No") : this.i18n.tr("Yes");
            }
            case 5: {
                return attr.isHidden() ? this.i18n.tr("Yes") : this.i18n.tr("No");
            }
            case 3: {
                return attr.isMandatory() ? this.i18n.tr("Yes") : this.i18n.tr("No");
            }
            case 4: {
                return attr.isUnique() ? this.i18n.tr("Yes") : this.i18n.tr("No");
            }
            case 0: {
                return attr.getName();
            }
            case 8: {
                return Integer.toString(attr.getRangeMax());
            }
            case 7: {
                return Integer.toString(attr.getRangeMin());
            }
            case 9: {
                return SYSTEM_TYPE[attr.getSystemType().getValue()];
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

