/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.assetmanagement.widgets.AssetPropertyEditor;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EditAssetPropertyDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(EditAssetPropertyDialog.class);
    private String value;
    private AssetAttribute attribute;
    private AssetPropertyEditor editor;

    public EditAssetPropertyDialog(Shell parentShell, String attributeName, String value) {
        super(parentShell);
        this.attribute = (AssetAttribute)Registry.getSession().getAssetManagementSchema().get(attributeName);
        this.value = value;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Edit Asset Attribute"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.editor = new AssetPropertyEditor(dialogArea, 0, this.attribute);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        this.editor.setLayoutData((Object)gd);
        this.editor.setValue(this.value);
        return dialogArea;
    }

    public String getValue() {
        return this.value;
    }

    protected void okPressed() {
        if (!this.editor.validateInput()) {
            WidgetHelper.adjustWindowSize((Window)this);
            return;
        }
        this.value = this.editor.getValue();
        super.okPressed();
    }
}

