/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views.helpers;

import java.util.ArrayList;
import java.util.List;
import org.netxms.client.AgentList;
import org.netxms.client.AgentParameter;
import org.netxms.client.AgentTable;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.AgentDataTreeNode;

/*
 * Exception performing whole class analysis ignored.
 */
public class AgentDataTreeNode
implements Comparable<AgentDataTreeNode> {
    private String name;
    private String fullName;
    private String description;
    private String dataType;
    private NodeType type;
    private AgentDataTreeNode parent;
    private List<AgentDataTreeNode> children;

    public AgentDataTreeNode(String name, String fullName, NodeType type, String description, String dataType) {
        this.name = name;
        this.fullName = fullName;
        this.type = type;
        this.description = description;
        this.dataType = dataType;
        this.parent = null;
        this.children = new ArrayList();
    }

    public AgentDataTreeNode(String name, NodeType type) {
        this(name, null, type, null, null);
    }

    public void addChild(AgentDataTreeNode child) {
        child.parent = this;
        this.children.add(child);
    }

    public AgentDataTreeNode getChild(String name) {
        for (AgentDataTreeNode child : this.children) {
            if (!child.name.equals(name)) continue;
            return child;
        }
        return null;
    }

    public String getName() {
        return this.fullName != null ? this.fullName : this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public NodeType getType() {
        return this.type;
    }

    public AgentDataTreeNode getParent() {
        return this.parent;
    }

    public List<AgentDataTreeNode> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean isLeaf() {
        return this.type == NodeType.PARAMETER || this.type == NodeType.LIST || this.type == NodeType.TABLE;
    }

    public List<AgentDataTreeNode> collectLeafNodes() {
        ArrayList<AgentDataTreeNode> leaves = new ArrayList<AgentDataTreeNode>();
        this.collectLeafNodesRecursive(leaves);
        return leaves;
    }

    private void collectLeafNodesRecursive(List<AgentDataTreeNode> leaves) {
        if (this.isLeaf()) {
            leaves.add(this);
        } else {
            for (AgentDataTreeNode child : this.children) {
                child.collectLeafNodesRecursive(leaves);
            }
        }
    }

    @Override
    public int compareTo(AgentDataTreeNode other) {
        boolean otherIsCategory;
        boolean thisIsCategory = this.type == NodeType.CATEGORY || this.type == NodeType.ROOT;
        boolean bl = otherIsCategory = other.type == NodeType.CATEGORY || other.type == NodeType.ROOT;
        if (thisIsCategory && !otherIsCategory) {
            return -1;
        }
        if (!thisIsCategory && otherIsCategory) {
            return 1;
        }
        return this.name.compareToIgnoreCase(other.name);
    }

    public static AgentDataTreeNode[] buildTree(List<AgentParameter> parameters, List<AgentList> lists, List<AgentTable> tables) {
        AgentDataTreeNode parametersRoot = new AgentDataTreeNode("Parameters", NodeType.ROOT);
        AgentDataTreeNode listsRoot = new AgentDataTreeNode("Lists", NodeType.ROOT);
        AgentDataTreeNode tablesRoot = new AgentDataTreeNode("Tables", NodeType.ROOT);
        if (parameters != null) {
            for (AgentParameter param : parameters) {
                AgentDataTreeNode.addToTree((AgentDataTreeNode)parametersRoot, (String)param.getName(), (String)param.getDescription(), (String)param.getDataType().toString(), (NodeType)NodeType.PARAMETER);
            }
        }
        if (lists != null) {
            for (AgentList list : lists) {
                AgentDataTreeNode.addToTree((AgentDataTreeNode)listsRoot, (String)list.getName(), (String)list.getDescription(), null, (NodeType)NodeType.LIST);
            }
        }
        if (tables != null) {
            for (AgentTable table : tables) {
                AgentDataTreeNode.addToTree((AgentDataTreeNode)tablesRoot, (String)table.getName(), (String)table.getDescription(), null, (NodeType)NodeType.TABLE);
            }
        }
        AgentDataTreeNode.sortChildren((AgentDataTreeNode)parametersRoot);
        AgentDataTreeNode.sortChildren((AgentDataTreeNode)listsRoot);
        AgentDataTreeNode.sortChildren((AgentDataTreeNode)tablesRoot);
        return new AgentDataTreeNode[]{parametersRoot, listsRoot, tablesRoot};
    }

    private static void addToTree(AgentDataTreeNode root, String fullName, String description, String dataType, NodeType leafType) {
        String[] parts = fullName.split("\\.");
        if (parts.length == 1) {
            root.addChild(new AgentDataTreeNode(fullName, fullName, leafType, description, dataType));
            return;
        }
        AgentDataTreeNode current = root;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            AgentDataTreeNode child = current.getChild(part);
            if (child == null) {
                child = new AgentDataTreeNode(part, null, NodeType.CATEGORY, null, null);
                current.addChild(child);
            }
            current = child;
        }
        String leafName = parts[parts.length - 1];
        current.addChild(new AgentDataTreeNode(leafName, fullName, leafType, description, dataType));
    }

    private static void sortChildren(AgentDataTreeNode node) {
        node.children.sort(null);
        for (AgentDataTreeNode child : node.children) {
            AgentDataTreeNode.sortChildren((AgentDataTreeNode)child);
        }
    }

    public String toString() {
        return this.name;
    }
}

