/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.agent.config.AgentConfiguration;
import org.netxms.client.agent.config.AgentConfigurationHandle;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.views.AgentConfigurationsManager;
import org.netxms.nxmc.modules.agentmanagement.views.StoredAgentConfigurationEditor;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class AgentConfigurationsManager
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(AgentConfigurationsManager.class);
    private NXCSession session = Registry.getSession();
    private TableViewer viewer;
    private Action actionNew;
    private Action actionEdit;
    private Action actionRename;
    private Action actionDelete;
    private Action actionMoveUp;
    private Action actionMoveDown;
    private List<AgentConfigurationHandle> elements;

    public AgentConfigurationsManager() {
        super(LocalizationHelper.getI18n(AgentConfigurationsManager.class).tr("Agent Configurations"), ResourceManager.getImageDescriptor((String)"icons/config-views/tunnel_manager.png"), "AgentConfigurationsManager", true);
    }

    protected void createContent(Composite parent) {
        this.viewer = new TableViewer(parent, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        ConfigurationFilter filter = new ConfigurationFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.createActions();
        this.createPopupMenu();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void createActions() {
        this.actionNew = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionNew);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRename = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("F2", (IAction)this.actionRename);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
        this.actionMoveUp = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMoveDown = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void moveUp() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentConfigurationHandle element1 = (AgentConfigurationHandle)selection.getFirstElement();
        int index = this.elements.indexOf(element1);
        if (index <= 0) {
            return;
        }
        AgentConfigurationHandle element2 = (AgentConfigurationHandle)this.elements.get(index - 1);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void moveDown() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentConfigurationHandle element1 = (AgentConfigurationHandle)selection.getFirstElement();
        int index = this.elements.indexOf(element1);
        if (index >= this.elements.size() - 1) {
            return;
        }
        AgentConfigurationHandle element2 = (AgentConfigurationHandle)this.elements.get(index + 1);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editConfig() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentConfigurationHandle h = (AgentConfigurationHandle)selection.getFirstElement();
        this.openView((View)new StoredAgentConfigurationEditor(h.getId(), h.getName()));
    }

    private void renameConfig() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentConfigurationHandle h = (AgentConfigurationHandle)selection.getFirstElement();
        InputDialog dlg = new InputDialog(this.getWindow().getShell(), this.i18n.tr("Rename Configuration"), this.i18n.tr("Configuration name"), h.getName(), (IInputValidator)new /* Unavailable Anonymous Inner Class!! */);
        if (dlg.open() != 0) {
            return;
        }
        String newName = dlg.getValue();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteConfig() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirm Delete"), (String)this.i18n.tr("Selected configurations will be deleted. Are you sure?"))) {
            return;
        }
        ArrayList<Long> deleteList = new ArrayList<Long>();
        for (Object o : selection.toList()) {
            deleteList.add(((AgentConfigurationHandle)o).getId());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createNewConfig() {
        InputDialog dlg = new InputDialog(this.getWindow().getShell(), this.i18n.tr("Create New Configuration"), this.i18n.tr("Configuration name"), "", (IInputValidator)new /* Unavailable Anonymous Inner Class!! */);
        if (dlg.open() != 0) {
            return;
        }
        AgentConfiguration configuration = new AgentConfiguration();
        configuration.setName(dlg.getValue().trim());
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
    }

    public void refresh() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        long[] currentSelection = new long[selection.size()];
        int i = 0;
        for (Object o : selection.toList()) {
            currentSelection[i++] = ((AgentConfigurationHandle)o).getId();
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

