/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.localization;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.rap.rwt.RWT;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.TimeFormatter;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateFormatFactory {
    public static final int DATETIME_FORMAT_SERVER = 0;
    public static final int DATETIME_FORMAT_JVM = 1;
    public static final int DATETIME_FORMAT_CUSTOM = 2;
    private static final TimeFormatter TIME_FORMATTER = new /* Unavailable Anonymous Inner Class!! */;
    private I18n i18n = LocalizationHelper.getI18n(DateFormatFactory.class);
    private int dateTimeFormat = 0;
    private String dateFormatString;
    private String timeFormatString;
    private String shortTimeFormatString;

    public static void createInstance() {
        PreferenceStore ps = PreferenceStore.getInstance();
        DateFormatFactory instance = new DateFormatFactory();
        instance.dateTimeFormat = ps.getAsInteger("DateFormatFactory.Format.DateTime", 0);
        instance.dateFormatString = ps.getAsString("DateFormatFactory.Format.Date");
        instance.timeFormatString = ps.getAsString("DateFormatFactory.Format.Time");
        instance.shortTimeFormatString = ps.getAsString("DateFormatFactory.Format.ShortTime");
        RWT.getUISession().setAttribute("netxms.dateFormatFactory", (Object)instance);
        if (ps.getAsBoolean("DateFormatFactory.UseServerTimeZone", false)) {
            Registry.setServerTimeZone();
        } else {
            Registry.resetTimeZone();
        }
    }

    public static void updateFromPreferences() {
        PreferenceStore ps = PreferenceStore.getInstance();
        DateFormatFactory instance = DateFormatFactory.getInstance();
        instance.dateTimeFormat = ps.getAsInteger("DateFormatFactory.Format.DateTime", 0);
        instance.dateFormatString = ps.getAsString("DateFormatFactory.Format.Date");
        instance.timeFormatString = ps.getAsString("DateFormatFactory.Format.Time");
        instance.shortTimeFormatString = ps.getAsString("DateFormatFactory.Format.ShortTime");
        if (ps.getAsBoolean("DateFormatFactory.UseServerTimeZone", false)) {
            Registry.setServerTimeZone();
        } else {
            Registry.resetTimeZone();
        }
    }

    public static TimeFormatter getTimeFormatter() {
        return TIME_FORMATTER;
    }

    private static DateFormatFactory getInstance() {
        return (DateFormatFactory)RWT.getUISession().getAttribute("netxms.dateFormatFactory");
    }

    public static DateFormat getDateTimeFormat() {
        DateFormatFactory instance = DateFormatFactory.getInstance();
        DateFormat df = switch (instance.dateTimeFormat) {
            case 0 -> {
                NXCSession session = Registry.getSession();
                yield new SimpleDateFormat(session.getDateFormat() + " " + session.getTimeFormat());
            }
            case 2 -> {
                try {
                    yield new SimpleDateFormat(instance.dateFormatString + " " + instance.timeFormatString);
                }
                catch (IllegalArgumentException e) {
                    yield DateFormat.getDateTimeInstance(3, 2);
                }
            }
            default -> DateFormat.getDateTimeInstance(3, 2);
        };
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getDateFormat() {
        DateFormatFactory instance = DateFormatFactory.getInstance();
        DateFormat df = switch (instance.dateTimeFormat) {
            case 0 -> {
                NXCSession session = Registry.getSession();
                yield new SimpleDateFormat(session.getDateFormat());
            }
            case 2 -> {
                try {
                    yield new SimpleDateFormat(instance.dateFormatString);
                }
                catch (IllegalArgumentException e) {
                    yield DateFormat.getDateInstance(3);
                }
            }
            default -> DateFormat.getDateInstance(3);
        };
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getTimeFormat() {
        DateFormatFactory instance = DateFormatFactory.getInstance();
        DateFormat df = switch (instance.dateTimeFormat) {
            case 0 -> {
                NXCSession session = Registry.getSession();
                yield new SimpleDateFormat(session.getTimeFormat());
            }
            case 2 -> {
                try {
                    yield new SimpleDateFormat(instance.timeFormatString);
                }
                catch (IllegalArgumentException e) {
                    yield DateFormat.getTimeInstance(2);
                }
            }
            default -> DateFormat.getTimeInstance(2);
        };
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getShortTimeFormat() {
        DateFormatFactory instance = DateFormatFactory.getInstance();
        DateFormat df = switch (instance.dateTimeFormat) {
            case 0 -> {
                NXCSession session = Registry.getSession();
                yield new SimpleDateFormat(session.getShortTimeFormat());
            }
            case 2 -> {
                try {
                    yield new SimpleDateFormat(instance.shortTimeFormatString);
                }
                catch (IllegalArgumentException e) {
                    yield DateFormat.getTimeInstance(3);
                }
            }
            default -> DateFormat.getTimeInstance(3);
        };
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static String formatTimeDifference(long seconds, boolean showSeconds) {
        long hours;
        StringBuilder sb = new StringBuilder();
        long days = seconds / 86400L;
        if (days > 0L) {
            DateFormatFactory instance = DateFormatFactory.getInstance();
            sb.append(instance.i18n.trn("{0} day", "{0} days", days, (Object)days));
            sb.append(", ");
            seconds -= days * 86400L;
        }
        if ((hours = seconds / 3600L) < 10L) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        long minutes = (seconds -= hours * 3600L) / 60L;
        if (minutes < 10L) {
            sb.append('0');
        }
        sb.append(minutes);
        if (showSeconds) {
            sb.append(':');
            if ((seconds %= 60L) < 10L) {
                sb.append('0');
            }
            sb.append(seconds);
        }
        return sb.toString();
    }

    public static String formatTimeDifference(Date start, boolean showSeconds) {
        long seconds = (System.currentTimeMillis() - start.getTime()) / 1000L;
        return DateFormatFactory.formatTimeDifference((long)seconds, (boolean)showSeconds);
    }
}

