/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PinLocation;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewContainer;
import org.netxms.nxmc.base.views.ViewFolderSelectionListener;
import org.netxms.nxmc.base.views.ViewWithContext;
import org.netxms.nxmc.keyboard.KeyStroke;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class ViewFolder
extends ViewContainer {
    private static final Logger logger = LoggerFactory.getLogger(ViewFolder.class);
    private final I18n i18n = LocalizationHelper.getI18n(ViewFolder.class);
    private CTabFolder tabFolder;
    private Composite topRightControl;
    private boolean allViewsAreCloseable = false;
    private boolean enableViewExtraction;
    private boolean enableViewPinning;
    private boolean disposeWhenEmpty = false;
    private boolean useGlobalViewId = false;
    private boolean enableViewHide = false;
    private String preferredViewId = null;
    private String lastViewId = null;
    private View activeView = null;
    private CTabItem contextMenuTabItem = null;
    private boolean contextChange = false;
    private Map<String, View> views = new HashMap();
    private Map<String, CTabItem> tabs = new HashMap();
    private Set<ViewFolderSelectionListener> selectionListeners = new HashSet();

    public ViewFolder(Window window, Perspective perspective, Composite parent, boolean enableViewExtraction, boolean enableViewPinning, boolean enableNavigationHistory, boolean enableViewHide) {
        super(window, perspective, parent, 0);
        this.enableViewExtraction = enableViewExtraction;
        this.enableViewPinning = enableViewPinning;
        this.enableViewHide = enableViewHide;
        this.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder((Composite)this, 2176);
        this.tabFolder.setUnselectedCloseVisible(true);
        WidgetHelper.disableTabFolderSelectionBar((CTabFolder)this.tabFolder);
        this.tabFolder.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.tabFolder.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.topRightControl = new Composite((Composite)this.tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.topRightControl.setLayout((Layout)layout);
        this.tabFolder.setTopRight((Control)this.topRightControl);
        this.viewToolBarManager = new ToolBarManager(8519744);
        this.viewToolBar = this.viewToolBarManager.createControl(this.topRightControl);
        this.viewToolBar.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewControlBar = new ToolBar(this.topRightControl, 8519744);
        this.viewControlBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        if (enableNavigationHistory) {
            this.navigationBack = new ToolItem(this.viewControlBar, 8);
            this.navigationBack.setImage(SharedIcons.IMG_NAV_BACKWARD);
            this.navigationBack.setToolTipText(this.i18n.tr("Back (Alt+Left)"));
            this.navigationBack.setEnabled(false);
            this.navigationBack.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(65536, 0x1000003, (IAction)new /* Unavailable Anonymous Inner Class!! */);
            this.navigationForward = new ToolItem(this.viewControlBar, 8);
            this.navigationForward.setImage(SharedIcons.IMG_NAV_FORWARD);
            this.navigationForward.setToolTipText(this.i18n.tr("Forward (Alt+Right)"));
            this.navigationForward.setEnabled(false);
            this.navigationForward.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(65536, 0x1000004, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.refreshView = new ToolItem(this.viewControlBar, 8);
        this.refreshView.setImage(SharedIcons.IMG_REFRESH);
        this.refreshView.setToolTipText(this.i18n.tr("Refresh (F5)"));
        this.refreshView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keyBindingManager.addBinding(0, 0x100000E, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        if (enableViewPinning) {
            Menu pinMenu = this.createPinMenu();
            ToolItem pinView = new ToolItem(this.viewControlBar, 4);
            pinView.setImage(SharedIcons.IMG_PIN);
            pinView.setToolTipText(this.i18n.tr("Pin view (F7)"));
            pinView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(0, 0x1000010, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (enableViewExtraction) {
            ToolItem popOutView = new ToolItem(this.viewControlBar, 8);
            popOutView.setImage(SharedIcons.IMG_POP_OUT);
            popOutView.setToolTipText(this.i18n.tr("Pop out view (F8)"));
            popOutView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.keyBindingManager.addBinding(0, 0x1000011, (IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.keyBindingManager.addBinding("M1+W", (IAction)new /* Unavailable Anonymous Inner Class!! */);
        this.createTabContextMenu();
    }

    private void createTabContextMenu() {
        MenuManager tabMenuManager = new MenuManager();
        tabMenuManager.setRemoveAllWhenShown(true);
        tabMenuManager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = tabMenuManager.createContextMenu((Control)this.tabFolder);
        this.tabFolder.setMenu(menu);
        this.tabFolder.addMenuDetectListener((MenuDetectListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fillTabContextMenu(IMenuManager manager) {
        if (this.contextMenuTabItem == null) {
            return;
        }
        View view = (View)this.contextMenuTabItem.getData("view");
        if (this.allViewsAreCloseable || view.isCloseable()) {
            manager.add((IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.enableViewPinning) {
            manager.add((IContributionItem)new Separator());
            this.createPinMenuItem(manager, view, PinLocation.PINBOARD, this.i18n.tr("&Pin to pinboard"));
            this.createPinMenuItem(manager, view, PinLocation.LEFT, this.i18n.tr("Pin at &left"));
            this.createPinMenuItem(manager, view, PinLocation.RIGHT, this.i18n.tr("Pin at &right"));
            this.createPinMenuItem(manager, view, PinLocation.BOTTOM, this.i18n.tr("Pin at &bottom"));
        }
        if (this.enableViewExtraction) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.enableViewHide && !view.isCloseable()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void hideView(View view) {
        PreferenceStore preferenceStore = PreferenceStore.getInstance();
        preferenceStore.set("HideView." + view.getBaseId(), true);
        this.updateViewSet();
    }

    private Menu createPinMenu() {
        Menu menu = new Menu((Control)this.viewControlBar);
        this.createPinMenuItem(menu, PinLocation.PINBOARD, this.i18n.tr("&Pinboard"));
        this.createPinMenuItem(menu, PinLocation.LEFT, this.i18n.tr("&Left"));
        this.createPinMenuItem(menu, PinLocation.RIGHT, this.i18n.tr("&Right"));
        this.createPinMenuItem(menu, PinLocation.BOTTOM, this.i18n.tr("&Bottom"));
        return menu;
    }

    private void createPinMenuItem(Menu menu, PinLocation location, String name) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(name);
        item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createPinMenuItem(IMenuManager manager, View view, PinLocation location, String name) {
        manager.add((IAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addView(View view) {
        this.addView(view, false, false);
    }

    public void addView(View view, boolean activate, boolean ignoreContext) {
        String viewId = this.getViewId(view);
        View currentView = (View)this.views.get(viewId);
        if (currentView == view) {
            return;
        }
        if (currentView != null) {
            logger.debug("Disposing existing view with ID " + viewId + " to replace with new instance");
            boolean originalDisposeWhenEmpty = this.disposeWhenEmpty;
            this.disposeWhenEmpty = false;
            currentView.dispose();
            CTabItem tabItem = (CTabItem)this.tabs.remove(viewId);
            if (tabItem != null) {
                tabItem.dispose();
            }
            this.disposeWhenEmpty = originalDisposeWhenEmpty;
        }
        this.views.put(viewId, view);
        if (ignoreContext || !(view instanceof ViewWithContext) || ((ViewWithContext)view).isValidForContext(this.context) && !((ViewWithContext)view).isHidden()) {
            view.create((ViewContainer)this, (Composite)this.tabFolder, this.onFilterCloseCallback);
            CTabItem tabItem = this.createViewTab(view, ignoreContext);
            if (activate || this.activeView == null) {
                this.tabFolder.setSelection(tabItem);
                this.activateView(view, tabItem);
            }
        }
    }

    public View findView(String id) {
        return (View)this.views.get(id);
    }

    public void removeView(String id) {
        View view = (View)this.views.remove(id);
        if (view != null) {
            this.closeView(view);
        }
    }

    public View[] getAllViews() {
        return (View[])this.views.values().toArray(View[]::new);
    }

    public boolean showView(String viewId) {
        View view = (View)this.views.get(viewId);
        if (view == null) {
            return false;
        }
        CTabItem tabItem = (CTabItem)this.tabs.get(viewId);
        if (tabItem == null) {
            return false;
        }
        this.tabFolder.setSelection(tabItem);
        this.activateView(view, tabItem);
        return true;
    }

    private void prepareViewActivation(View view) {
        this.updateViewMenu(view);
        this.updateViewToolBar(view);
        if (view.hasFilter()) {
            if (this.enableFilter == null) {
                this.enableFilter = new ToolItem(this.viewControlBar, 32, this.navigationBack != null ? 2 : 0);
                this.enableFilter.setImage(SharedIcons.IMG_FILTER);
                this.enableFilter.setToolTipText(String.format(this.i18n.tr("Show filter (%s)"), KeyStroke.normalizeDefinition((String)"M1+F2")));
                this.enableFilter.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.enableFilter.setSelection(view.isFilterEnabled());
            this.showFilterAction.setEnabled(true);
        } else {
            if (this.enableFilter != null) {
                this.enableFilter.dispose();
                this.enableFilter = null;
            }
            this.showFilterAction.setEnabled(false);
        }
        this.layout(true, true);
    }

    private void activateView(View view, CTabItem tabItem) {
        if (view instanceof ViewWithContext && !ViewFolder.ignoreContextForView((CTabItem)tabItem) && ((ViewWithContext)view).getContext() != this.context) {
            ((ViewWithContext)view).setContext(this.context);
        }
        if (this.navigationBack != null && this.navigationForward != null) {
            this.navigationHistory = view instanceof NavigationView ? ((NavigationView)view).getNavigationHistory() : null;
            this.navigationForward.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoForward());
            this.navigationBack.setEnabled(this.navigationHistory != null && this.navigationHistory.canGoBackward());
        }
        if (this.activeView != null) {
            this.activeView.deactivate();
        }
        if (!this.contextChange) {
            this.lastViewId = this.activeView != null ? this.getViewId(this.activeView) : null;
        }
        this.prepareViewActivation(view);
        this.activeView = view;
        if (!this.contextChange) {
            this.preferredViewId = this.getViewId(this.activeView);
        }
        view.activate();
        this.updateRefreshActionState();
    }

    public boolean updateViewTrim(View view) {
        boolean updated = false;
        CTabItem tab = (CTabItem)this.tabs.get(this.getViewId(view));
        if (tab != null) {
            tab.setText(ViewFolder.ignoreContextForView((CTabItem)tab) ? view.getFullName() : view.getName());
            tab.setImage(view.getImage());
            updated = true;
        }
        return updated;
    }

    private CTabItem createViewTab(View view, boolean ignoreContext) {
        CTabItem i;
        View v;
        int index = 0;
        int priority = view.getPriority();
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        for (int j = 0; j < n && (v = (View)(i = cTabItemArray[j]).getData("view")).getPriority() <= priority; ++j) {
            ++index;
        }
        CTabItem tabItem = new CTabItem(this.tabFolder, 0, index);
        tabItem.setControl((Control)view.getViewArea());
        tabItem.setText(ignoreContext ? view.getFullName() : view.getName());
        tabItem.setImage(view.getImage());
        tabItem.setData("view", (Object)view);
        tabItem.setData("ignoreContext", (Object)ignoreContext);
        tabItem.setShowClose(this.allViewsAreCloseable || view.isCloseable());
        tabItem.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tabs.put(this.getViewId(view), tabItem);
        return tabItem;
    }

    protected void closeView(View view) {
        view.dispose();
        CTabItem tabItem = (CTabItem)this.tabs.remove(this.getViewId(view));
        if (tabItem != null) {
            tabItem.dispose();
        }
    }

    protected void extractView(View view) {
        if (view != this.getActiveView() && view instanceof ViewWithContext && !ViewFolder.ignoreContextForView((CTabItem)this.contextMenuTabItem) && ((ViewWithContext)view).getContext() != this.context) {
            ((ViewWithContext)view).setContext(this.context);
        }
        super.extractView(view);
    }

    protected void pinView(View view, PinLocation location) {
        if (view != this.getActiveView() && view instanceof ViewWithContext && !ViewFolder.ignoreContextForView((CTabItem)this.contextMenuTabItem) && ((ViewWithContext)view).getContext() != this.context) {
            ((ViewWithContext)view).setContext(this.context);
        }
        super.pinView(view, location);
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        if (context == this.context) {
            return;
        }
        if (this.activeView != null) {
            this.activeView.deactivate();
        }
        this.context = context;
        this.updateViewSet();
        if (this.activeView != null) {
            if (this.activeView instanceof ViewWithContext) {
                ((ViewWithContext)this.activeView).setContext(context);
            }
            this.prepareViewActivation(this.activeView);
            this.activeView.activate();
        }
    }

    public void updateContext(Object context) {
        if (context == this.context) {
            return;
        }
        View currentActiveView = this.activeView;
        this.context = context;
        this.updateViewSet();
        if (this.activeView != null && this.activeView != currentActiveView) {
            if (this.activeView instanceof ViewWithContext) {
                ((ViewWithContext)this.activeView).setContext(context);
            }
            this.prepareViewActivation(this.activeView);
            this.activeView.activate();
        }
    }

    public void updateViewSet() {
        this.contextChange = true;
        boolean invalidActiveView = false;
        for (View view : this.views.values()) {
            if (!(view instanceof ViewWithContext)) continue;
            if (((ViewWithContext)view).isValidForContext(this.context) && !((ViewWithContext)view).isHidden()) {
                view.setVisible(true);
                if (this.tabs.containsKey(this.getViewId(view))) continue;
                if (view.isCreated()) {
                    view.setVisible(true);
                } else {
                    view.create((ViewContainer)this, (Composite)this.tabFolder, this.onFilterCloseCallback);
                }
                this.createViewTab(view, false);
                continue;
            }
            String viewId = this.getViewId(view);
            CTabItem tabItem = (CTabItem)this.tabs.remove(viewId);
            if (tabItem == null) continue;
            logger.debug("View " + viewId + " is not valid for current context");
            tabItem.setData("keepView", (Object)Boolean.TRUE);
            tabItem.dispose();
            view.setVisible(false);
            if (view != this.activeView) continue;
            invalidActiveView = true;
        }
        CTabItem tabItem = this.tabFolder.getSelection();
        View view = this.activeView = tabItem != null ? (View)tabItem.getData("view") : null;
        if (!(this.preferredViewId == null && this.lastViewId == null || this.activeView != null && this.preferredViewId.equals(this.getViewId(this.activeView)) || !this.showView(this.preferredViewId) && !this.showView(this.lastViewId))) {
            invalidActiveView = false;
        }
        if (invalidActiveView || this.tabFolder.getSelectionIndex() == -1) {
            this.tabFolder.setSelection(0);
            tabItem = this.tabFolder.getSelection();
            this.activeView = tabItem != null ? (View)tabItem.getData("view") : null;
        }
        this.contextChange = false;
    }

    protected View getActiveView() {
        return this.tabFolder.isDisposed() ? null : this.activeView;
    }

    public boolean isViewActive(View view) {
        return this.isActive && !this.tabFolder.isDisposed() && this.activeView == view;
    }

    public void addSelectionListener(ViewFolderSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(ViewFolderSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void fireSelectionListeners(View view) {
        for (ViewFolderSelectionListener l : this.selectionListeners) {
            l.viewSelected(view);
        }
    }

    public boolean areAllViewsCloseable() {
        return this.allViewsAreCloseable;
    }

    public void setAllViewsAsCloseable(boolean allViewsAreCloseable) {
        this.allViewsAreCloseable = allViewsAreCloseable;
    }

    public boolean isDisposeWhenEmpty() {
        return this.disposeWhenEmpty;
    }

    public void setDisposeWhenEmpty(boolean disposeWhenEmpty) {
        this.disposeWhenEmpty = disposeWhenEmpty;
    }

    private static boolean ignoreContextForView(CTabItem tabItem) {
        Object ignoreContext = tabItem.getData("ignoreContext");
        return ignoreContext != null && ignoreContext instanceof Boolean && (Boolean)ignoreContext != false;
    }

    public boolean isUseGlobalViewId() {
        return this.useGlobalViewId;
    }

    public void setUseGlobalViewId(boolean useGlobalViewId) {
        this.useGlobalViewId = useGlobalViewId;
    }

    private String getViewId(View view) {
        return this.useGlobalViewId ? view.getGlobalId() : view.getBaseId();
    }

    public boolean setFocus() {
        View view = this.getActiveView();
        if (view != null && !view.isClientAreaDisposed()) {
            view.setFocus();
        } else {
            super.setFocus();
        }
        return true;
    }

    public void saveState(Memento memento) {
        ArrayList<String> viewList = new ArrayList<String>();
        for (View v : this.views.values()) {
            String id = v.getGlobalId();
            viewList.add(id);
            Memento viewConfig = new Memento();
            v.saveState(viewConfig);
            memento.set(id + ".state", viewConfig);
        }
        memento.set("ViewFolder.Views", viewList);
    }
}

