/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.BrandingProvider;
import org.netxms.nxmc.base.dialogs.AboutDialog;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public final class BrandingManager {
    private static final Logger logger = LoggerFactory.getLogger(BrandingManager.class);
    private static final List<BrandingProvider> providers = new ArrayList(0);

    public static String getProductName() {
        for (BrandingProvider p : providers) {
            String name = p.getProductName();
            if (name == null) continue;
            return name;
        }
        return "NetXMS";
    }

    public static String getWindowIconResourcePrefix() {
        for (BrandingProvider p : providers) {
            String prefix = p.getWindowIconResourcePrefix();
            if (prefix == null) continue;
            return prefix;
        }
        return "icons/window/";
    }

    public static String getClientProductName() {
        for (BrandingProvider p : providers) {
            String name = p.getClientProductName();
            if (name == null) continue;
            return name;
        }
        I18n i18n = LocalizationHelper.getI18n(BrandingManager.class);
        return i18n.tr("NetXMS Management Client");
    }

    public static ImageDescriptor getLoginImage() {
        for (BrandingProvider p : providers) {
            ImageDescriptor image = p.getLoginImage();
            if (image == null) continue;
            return image;
        }
        return ResourceManager.getImageDescriptor((String)(WidgetHelper.isSystemDarkTheme() ? "icons/login-dark-mode.png" : "icons/login.png"));
    }

    public static RGB getLoginImageBackground() {
        for (BrandingProvider p : providers) {
            RGB color = p.getLoginImageBackground();
            if (color == null) continue;
            return color;
        }
        return new RGB(14, 50, 78);
    }

    public static ImageDescriptor getAppHeaderImage() {
        for (BrandingProvider p : providers) {
            ImageDescriptor image = p.getAppHeaderImage();
            if (image == null) continue;
            return image;
        }
        return ResourceManager.getImageDescriptor((String)"icons/app-logo.png");
    }

    public static RGB getAppHeaderBackground() {
        for (BrandingProvider p : providers) {
            RGB color = p.getAppHeaderBackground();
            if (color == null) continue;
            return color;
        }
        return ThemeEngine.getBackgroundColorDefinition((String)"Window.Header");
    }

    public static String getDefaultPerspective() {
        for (BrandingProvider p : providers) {
            String pid = p.getDefaultPerspective();
            if (pid == null) continue;
            return pid;
        }
        return null;
    }

    public static Dialog createAboutDialog(Shell parentShell) {
        for (BrandingProvider p : providers) {
            Dialog d = p.createAboutDialog(parentShell);
            if (d == null) continue;
            return d;
        }
        return new AboutDialog(parentShell);
    }

    public static String getAdministratorGuideURL() {
        for (BrandingProvider p : providers) {
            String url = p.getAdministratorGuideURL();
            if (url == null) continue;
            return url;
        }
        return "https://go.netxms.com/adminguide-online";
    }

    public static boolean isExtendedHelpMenuEnabled() {
        for (BrandingProvider p : providers) {
            Boolean enabled = p.isExtendedHelpMenuEnabled();
            if (enabled == null) continue;
            return enabled;
        }
        return true;
    }

    public static boolean isWelcomePageEnabled() {
        for (BrandingProvider p : providers) {
            Boolean enabled = p.isWelcomePageEnabled();
            if (enabled == null) continue;
            return enabled;
        }
        return true;
    }

    static {
        ServiceLoader<BrandingProvider> loader = ServiceLoader.load(BrandingProvider.class, BrandingManager.class.getClassLoader());
        for (BrandingProvider p : loader) {
            logger.info("Registered branding provider \"" + p.getDescription() + "\" (" + p.getClass().getName() + ")");
            providers.add(p);
        }
        logger.info("Branding manager initialized " + (providers.isEmpty() ? "without" : "with") + " custom providers");
    }
}

