/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONObject;
import org.netxms.base.Glob;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.MapType;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.NetworkService;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.VPNConnector;
import org.netxms.websvc.WebSvcException;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.handlers.AbstractObjectHandler;
import org.netxms.websvc.json.JsonTools;
import org.netxms.websvc.json.ResponseContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Objects
extends AbstractObjectHandler {
    private Logger log = LoggerFactory.getLogger(AbstractHandler.class);

    /*
     * Could not resolve type clashes
     */
    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        if (!session.areObjectsSynchronized()) {
            session.syncObjects();
        }
        boolean topLevelOnly = query.get("topLevelOnly") != null ? Boolean.parseBoolean(query.get("topLevelOnly")) : false;
        List<AbstractObject> objects = topLevelOnly ? Arrays.asList(session.getTopLevelObjects()) : session.getAllObjects();
        boolean useRegex = query.get("regex") != null ? Boolean.parseBoolean(query.get("regex")) : false;
        String areaFilter = query.get("area");
        String classFilter = query.get("class");
        String nameFilter = query.get("name");
        String parentFilter = query.get("parent");
        String primaryNameFilter = query.get("primaryName");
        String stateFilter = query.get("state");
        String zoneFilter = query.get("zone");
        Pattern nameFilterRegex = null;
        if (nameFilter != null && !nameFilter.isEmpty()) {
            nameFilterRegex = Pattern.compile(nameFilter, 2);
        }
        Pattern primaryNameFilterRegex = null;
        if (primaryNameFilter != null && !primaryNameFilter.isEmpty()) {
            primaryNameFilterRegex = Pattern.compile(primaryNameFilter, 2);
        }
        Integer stateFilterValue = null;
        if (stateFilter != null && !stateFilter.isEmpty()) {
            try {
                stateFilterValue = stateFilter.startsWith("0x") ? Integer.parseInt(stateFilter.substring(2), 16) : Integer.parseInt(stateFilter);
            }
            catch (NumberFormatException e) {
                this.log.debug("Invalid state filter " + stateFilter);
            }
        }
        HashMap<String, Object> customAttributes = null;
        for (String k : query.keySet()) {
            if (!k.startsWith("@")) continue;
            if (customAttributes == null) {
                customAttributes = new HashMap<String, Object>();
            }
            if (useRegex) {
                customAttributes.put(k.substring(1), Pattern.compile(query.get(k), 2));
                continue;
            }
            customAttributes.put(k.substring(1), query.get(k));
        }
        if (areaFilter != null || classFilter != null || customAttributes != null || nameFilter != null || parentFilter != null || primaryNameFilter != null || stateFilterValue != null || zoneFilter != null) {
            long parentId;
            double[] area = null;
            if (areaFilter != null) {
                String[] parts = areaFilter.split(",");
                if (parts.length == 4) {
                    try {
                        area = new double[4];
                        for (int i = 0; i < 4; ++i) {
                            area[i] = Double.parseDouble(parts[i]);
                        }
                    }
                    catch (NumberFormatException e) {
                        this.log.warn("Invalid area filter " + areaFilter);
                    }
                } else {
                    this.log.warn("Invalid area filter " + areaFilter);
                }
            }
            String[] classes = null;
            if (classFilter != null && !classFilter.isEmpty()) {
                classes = classFilter.split(",");
            }
            if (parentFilter != null) {
                try {
                    parentId = Long.parseLong(parentFilter);
                }
                catch (NumberFormatException e) {
                    throw new WebSvcException(12);
                }
            } else {
                parentId = 0L;
            }
            long[] zones = null;
            if (zoneFilter != null) {
                String[] parts = zoneFilter.split(",");
                try {
                    zones = new long[parts.length];
                    for (int i = 0; i < parts.length; ++i) {
                        zones[i] = Long.parseLong(parts[i]);
                    }
                }
                catch (NumberFormatException e) {
                    this.log.warn("Invalid zone filter " + zoneFilter);
                }
            }
            ArrayList<AbstractObject> filteredObjects = new ArrayList<AbstractObject>();
            for (AbstractObject o : objects) {
                if (stateFilterValue != null && (!(o instanceof AbstractNode) || (stateFilterValue & ((AbstractNode)o).getStateFlags()) == 0)) continue;
                if (zones != null) {
                    long zoneUin = Objects.getZoneUin((AbstractObject)o);
                    if (zoneUin == -1L) continue;
                    int match = 0;
                    for (long z : zones) {
                        if (zoneUin != z) continue;
                        match = 1;
                        break;
                    }
                    if (match == 0) continue;
                }
                if (!useRegex ? nameFilter != null && !nameFilter.isEmpty() && !Glob.matchIgnoreCase((String)nameFilter, (String)o.getObjectName()) : nameFilterRegex != null && !nameFilterRegex.matcher(o.getObjectName()).matches()) continue;
                if (classes != null) {
                    boolean match = false;
                    for (String c : classes) {
                        if (!o.getObjectClassName().equalsIgnoreCase(c)) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                }
                if (parentId != 0L && !o.isChildOf(parentId) || area != null && !o.getGeolocation().isWithinArea(area[0], area[1], area[2], area[3])) continue;
                if (customAttributes != null) {
                    String value;
                    if (o.getCustomAttributes().isEmpty()) continue;
                    boolean match = true;
                    if (useRegex) {
                        for (Map.Entry e : customAttributes.entrySet()) {
                            value = o.getCustomAttributeValue((String)e.getKey());
                            if (value != null && ((Pattern)e.getValue()).matcher(value).matches()) continue;
                            match = false;
                            break;
                        }
                    } else {
                        for (Map.Entry e : customAttributes.entrySet()) {
                            value = o.getCustomAttributeValue((String)e.getKey());
                            if (value != null && Glob.matchIgnoreCase((String)((String)e.getValue()), (String)value)) continue;
                            match = false;
                            break;
                        }
                    }
                    if (!match) continue;
                }
                if (primaryNameFilter != null) {
                    if (!(o instanceof AbstractNode)) continue;
                    AbstractNode node = (AbstractNode)o;
                    if (useRegex ? primaryNameFilterRegex != null && !primaryNameFilterRegex.matcher(node.getPrimaryName()).matches() : primaryNameFilter != null && !primaryNameFilter.isEmpty() && !Glob.matchIgnoreCase((String)primaryNameFilter, (String)node.getPrimaryName())) continue;
                }
                filteredObjects.add(o);
            }
            objects = filteredObjects;
        }
        return new ResponseContainer("objects", objects);
    }

    private static long getZoneUin(AbstractObject obj) {
        if (obj instanceof AbstractNode) {
            return ((AbstractNode)obj).getZoneId();
        }
        if (obj instanceof Subnet) {
            return ((Subnet)obj).getZoneId();
        }
        if (obj instanceof Interface) {
            return ((Interface)obj).getZoneId();
        }
        if (obj instanceof NetworkService) {
            return ((NetworkService)obj).getParentNode().getZoneId();
        }
        if (obj instanceof VPNConnector) {
            return ((VPNConnector)obj).getParentNode().getZoneId();
        }
        if (obj instanceof AccessPoint) {
            return ((AccessPoint)obj).getParentNode().getZoneId();
        }
        return -1L;
    }

    protected Object get(String id, Map<String, String> query) throws Exception {
        return this.getObject();
    }

    protected String getEntityIdFieldName() {
        return "object-id";
    }

    protected Object create(JSONObject data) throws Exception {
        int type = JsonTools.getIntFromJson((JSONObject)data, (String)"objectType", (int)-1);
        String name = JsonTools.getStringFromJson((JSONObject)data, (String)"name", null);
        long parentId = JsonTools.getLongFromJson((JSONObject)data, (String)"parentId", (long)-1L);
        if (type == -1 || name == null || parentId == -1L) {
            return this.createErrorResponseRepresentation(12);
        }
        NXCObjectCreationData createData = new NXCObjectCreationData(type, name, parentId);
        createData.setComments(JsonTools.getStringFromJson((JSONObject)data, (String)"comments", (String)createData.getComments()));
        createData.setCreationFlags(JsonTools.getIntFromJson((JSONObject)data, (String)"creationFlags", (int)createData.getFlags()));
        createData.setMapType(MapType.getByValue((int)JsonTools.getIntFromJson((JSONObject)data, (String)"mapType", (int)createData.getMapType().getValue())));
        createData.setZoneUIN(JsonTools.getIntFromJson((JSONObject)data, (String)"zoneUIN", (int)createData.getZoneUIN()));
        createData.setLinkedNodeId(JsonTools.getLongFromJson((JSONObject)data, (String)"linkedNodeId", (long)createData.getLinkedNodeId()));
        createData.setTemplate(JsonTools.getBooleanFromJson((JSONObject)data, (String)"template", (boolean)createData.isTemplate()));
        createData.setIfIndex(JsonTools.getIntFromJson((JSONObject)data, (String)"ifIndex", (int)createData.getIfIndex()));
        createData.setIfType(JsonTools.getIntFromJson((JSONObject)data, (String)"ifType", (int)createData.getIfType()));
        createData.setChassis(JsonTools.getIntFromJson((JSONObject)data, (String)"chassis", (int)createData.getChassis()));
        createData.setModule(JsonTools.getIntFromJson((JSONObject)data, (String)"module", (int)createData.getModule()));
        createData.setPIC(JsonTools.getIntFromJson((JSONObject)data, (String)"pic", (int)createData.getPIC()));
        createData.setPort(JsonTools.getIntFromJson((JSONObject)data, (String)"port", (int)createData.getPort()));
        createData.setPhysicalPort(JsonTools.getBooleanFromJson((JSONObject)data, (String)"physicalPort", (boolean)createData.isPhysicalPort()));
        createData.setCreateStatusDci(JsonTools.getBooleanFromJson((JSONObject)data, (String)"createStatusDci", (boolean)createData.isCreateStatusDci()));
        createData.setDeviceId(JsonTools.getStringFromJson((JSONObject)data, (String)"deviceId", (String)createData.getDeviceId()));
        createData.setFlags(JsonTools.getIntFromJson((JSONObject)data, (String)"flags", (int)createData.getFlags()));
        createData.setInstanceDiscoveryMethod(JsonTools.getIntFromJson((JSONObject)data, (String)"instanceDiscoveryMethod", (int)createData.getInstanceDiscoveryMethod()));
        createData.setDeviceAddress(JsonTools.getStringFromJson((JSONObject)data, (String)"deviceAddress", (String)createData.getDeviceAddress()));
        createData.setVendor(JsonTools.getStringFromJson((JSONObject)data, (String)"vendor", (String)createData.getVendor()));
        createData.setModel(JsonTools.getStringFromJson((JSONObject)data, (String)"model", (String)createData.getModel()));
        createData.setSerialNumber(JsonTools.getStringFromJson((JSONObject)data, (String)"serialNumber", (String)createData.getSerialNumber()));
        createData.setModbusUnitId((short)JsonTools.getIntFromJson((JSONObject)data, (String)"modbusUnitId", (int)createData.getModbusUnitId()));
        NXCObjectModificationData mdObject = (NXCObjectModificationData)JsonTools.createGsonInstance().fromJson(data.toString(), NXCObjectModificationData.class);
        createData.updateFromModificationData(mdObject);
        NXCSession session = this.getSession();
        long nodeId = session.createObject(createData);
        mdObject.setObjectId(nodeId);
        session.modifyObject(mdObject);
        JSONObject result = new JSONObject();
        result.put("id", nodeId);
        return result;
    }

    protected Object update(String id, JSONObject data) throws Exception {
        NXCSession session = this.getSession();
        NXCObjectModificationData mdObject = (NXCObjectModificationData)JsonTools.createGsonInstance().fromJson(data.toString(), NXCObjectModificationData.class);
        mdObject.setObjectId(this.getObjectId());
        session.modifyObject(mdObject);
        return null;
    }

    protected Object delete(String id) throws Exception {
        NXCSession session = this.getSession();
        session.deleteObject(this.getObjectId());
        return null;
    }
}

