/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiProperties {
    private Logger log = LoggerFactory.getLogger(ApiProperties.class);
    private Properties properties = new Properties();
    private String host = "127.0.0.1";
    private int port = 4701;
    private boolean enableCompression;
    private long sessionTimeout = 300000L;

    public ApiProperties() {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream("/nxapisrv.properties");
            if (in != null) {
                this.properties.load(in);
                this.host = this.properties.getProperty("netxms.server.address", "127.0.0.1");
                this.port = this.getIntProperty("netxms.server.port", 4701);
                this.enableCompression = this.getBooleanProperty("netxms.server.enableCompression", true);
                this.sessionTimeout = this.getIntProperty("session.timeout", 300) * 1000;
            }
        }
        catch (Exception e) {
            this.log.warn("Cannot open property file", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int getIntProperty(String name, int defaultValue) {
        try {
            String v = this.properties.getProperty(name);
            if (v == null) {
                return defaultValue;
            }
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private boolean getBooleanProperty(String name, boolean defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(v);
    }

    public String getServerAddress() {
        return this.host;
    }

    public int getServerPort() {
        return this.port;
    }

    public boolean isCompressionEnabled() {
        return this.enableCompression;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }
}

