/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.asn1.util;

import org.python.bouncycastle.asn1.ASN1BMPString;
import org.python.bouncycastle.asn1.ASN1BitString;
import org.python.bouncycastle.asn1.ASN1Boolean;
import org.python.bouncycastle.asn1.ASN1Encodable;
import org.python.bouncycastle.asn1.ASN1Enumerated;
import org.python.bouncycastle.asn1.ASN1External;
import org.python.bouncycastle.asn1.ASN1GeneralizedTime;
import org.python.bouncycastle.asn1.ASN1GraphicString;
import org.python.bouncycastle.asn1.ASN1IA5String;
import org.python.bouncycastle.asn1.ASN1Integer;
import org.python.bouncycastle.asn1.ASN1Null;
import org.python.bouncycastle.asn1.ASN1NumericString;
import org.python.bouncycastle.asn1.ASN1ObjectDescriptor;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.ASN1OctetString;
import org.python.bouncycastle.asn1.ASN1Primitive;
import org.python.bouncycastle.asn1.ASN1PrintableString;
import org.python.bouncycastle.asn1.ASN1RelativeOID;
import org.python.bouncycastle.asn1.ASN1Sequence;
import org.python.bouncycastle.asn1.ASN1Set;
import org.python.bouncycastle.asn1.ASN1T61String;
import org.python.bouncycastle.asn1.ASN1TaggedObject;
import org.python.bouncycastle.asn1.ASN1UTCTime;
import org.python.bouncycastle.asn1.ASN1UTF8String;
import org.python.bouncycastle.asn1.ASN1Util;
import org.python.bouncycastle.asn1.ASN1VideotexString;
import org.python.bouncycastle.asn1.ASN1VisibleString;
import org.python.bouncycastle.asn1.BEROctetString;
import org.python.bouncycastle.asn1.BERSequence;
import org.python.bouncycastle.asn1.BERSet;
import org.python.bouncycastle.asn1.BERTaggedObject;
import org.python.bouncycastle.asn1.DERBitString;
import org.python.bouncycastle.asn1.DERSequence;
import org.python.bouncycastle.asn1.DERSet;
import org.python.bouncycastle.asn1.DERTaggedObject;
import org.python.bouncycastle.asn1.DLBitString;
import org.python.bouncycastle.util.Strings;
import org.python.bouncycastle.util.encoders.Hex;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    static void _dumpAsString(String string2, boolean bl, ASN1Primitive aSN1Primitive, StringBuffer stringBuffer) {
        String string3 = Strings.lineSeparator();
        if (aSN1Primitive instanceof ASN1Null) {
            stringBuffer.append(string2);
            stringBuffer.append("NULL");
            stringBuffer.append(string3);
        } else if (aSN1Primitive instanceof ASN1Sequence) {
            stringBuffer.append(string2);
            if (aSN1Primitive instanceof BERSequence) {
                stringBuffer.append("BER Sequence");
            } else if (aSN1Primitive instanceof DERSequence) {
                stringBuffer.append("DER Sequence");
            } else {
                stringBuffer.append("Sequence");
            }
            stringBuffer.append(string3);
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
            String string4 = string2 + TAB;
            int n = aSN1Sequence.size();
            for (int i = 0; i < n; ++i) {
                ASN1Dump._dumpAsString(string4, bl, aSN1Sequence.getObjectAt(i).toASN1Primitive(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof ASN1Set) {
            stringBuffer.append(string2);
            if (aSN1Primitive instanceof BERSet) {
                stringBuffer.append("BER Set");
            } else if (aSN1Primitive instanceof DERSet) {
                stringBuffer.append("DER Set");
            } else {
                stringBuffer.append("Set");
            }
            stringBuffer.append(string3);
            ASN1Set aSN1Set = (ASN1Set)aSN1Primitive;
            String string5 = string2 + TAB;
            int n = aSN1Set.size();
            for (int i = 0; i < n; ++i) {
                ASN1Dump._dumpAsString(string5, bl, aSN1Set.getObjectAt(i).toASN1Primitive(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof ASN1TaggedObject) {
            stringBuffer.append(string2);
            if (aSN1Primitive instanceof BERTaggedObject) {
                stringBuffer.append("BER Tagged ");
            } else if (aSN1Primitive instanceof DERTaggedObject) {
                stringBuffer.append("DER Tagged ");
            } else {
                stringBuffer.append("Tagged ");
            }
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
            stringBuffer.append(ASN1Util.getTagText(aSN1TaggedObject));
            if (!aSN1TaggedObject.isExplicit()) {
                stringBuffer.append(" IMPLICIT ");
            }
            stringBuffer.append(string3);
            String string6 = string2 + TAB;
            ASN1Dump._dumpAsString(string6, bl, aSN1TaggedObject.getBaseObject().toASN1Primitive(), stringBuffer);
        } else if (aSN1Primitive instanceof ASN1OctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Primitive;
            if (aSN1Primitive instanceof BEROctetString) {
                stringBuffer.append(string2 + "BER Constructed Octet String[" + aSN1OctetString.getOctets().length + "] ");
            } else {
                stringBuffer.append(string2 + "DER Octet String[" + aSN1OctetString.getOctets().length + "] ");
            }
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string2, aSN1OctetString.getOctets()));
            } else {
                stringBuffer.append(string3);
            }
        } else if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
            stringBuffer.append(string2 + "ObjectIdentifier(" + ((ASN1ObjectIdentifier)aSN1Primitive).getId() + ")" + string3);
        } else if (aSN1Primitive instanceof ASN1RelativeOID) {
            stringBuffer.append(string2 + "RelativeOID(" + ((ASN1RelativeOID)aSN1Primitive).getId() + ")" + string3);
        } else if (aSN1Primitive instanceof ASN1Boolean) {
            stringBuffer.append(string2 + "Boolean(" + ((ASN1Boolean)aSN1Primitive).isTrue() + ")" + string3);
        } else if (aSN1Primitive instanceof ASN1Integer) {
            stringBuffer.append(string2 + "Integer(" + ((ASN1Integer)aSN1Primitive).getValue() + ")" + string3);
        } else if (aSN1Primitive instanceof ASN1BitString) {
            ASN1BitString aSN1BitString = (ASN1BitString)aSN1Primitive;
            byte[] byArray = aSN1BitString.getBytes();
            int n = aSN1BitString.getPadBits();
            if (aSN1BitString instanceof DERBitString) {
                stringBuffer.append(string2 + "DER Bit String[" + byArray.length + ", " + n + "] ");
            } else if (aSN1BitString instanceof DLBitString) {
                stringBuffer.append(string2 + "DL Bit String[" + byArray.length + ", " + n + "] ");
            } else {
                stringBuffer.append(string2 + "BER Bit String[" + byArray.length + ", " + n + "] ");
            }
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string2, byArray));
            } else {
                stringBuffer.append(string3);
            }
        } else if (aSN1Primitive instanceof ASN1IA5String) {
            stringBuffer.append(string2 + "IA5String(" + ((ASN1IA5String)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1UTF8String) {
            stringBuffer.append(string2 + "UTF8String(" + ((ASN1UTF8String)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1NumericString) {
            stringBuffer.append(string2 + "NumericString(" + ((ASN1NumericString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1PrintableString) {
            stringBuffer.append(string2 + "PrintableString(" + ((ASN1PrintableString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1VisibleString) {
            stringBuffer.append(string2 + "VisibleString(" + ((ASN1VisibleString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1BMPString) {
            stringBuffer.append(string2 + "BMPString(" + ((ASN1BMPString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1T61String) {
            stringBuffer.append(string2 + "T61String(" + ((ASN1T61String)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1GraphicString) {
            stringBuffer.append(string2 + "GraphicString(" + ((ASN1GraphicString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1VideotexString) {
            stringBuffer.append(string2 + "VideotexString(" + ((ASN1VideotexString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1UTCTime) {
            stringBuffer.append(string2 + "UTCTime(" + ((ASN1UTCTime)aSN1Primitive).getTime() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1GeneralizedTime) {
            stringBuffer.append(string2 + "GeneralizedTime(" + ((ASN1GeneralizedTime)aSN1Primitive).getTime() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1Enumerated) {
            ASN1Enumerated aSN1Enumerated = (ASN1Enumerated)aSN1Primitive;
            stringBuffer.append(string2 + "DER Enumerated(" + aSN1Enumerated.getValue() + ")" + string3);
        } else if (aSN1Primitive instanceof ASN1ObjectDescriptor) {
            ASN1ObjectDescriptor aSN1ObjectDescriptor = (ASN1ObjectDescriptor)aSN1Primitive;
            stringBuffer.append(string2 + "ObjectDescriptor(" + aSN1ObjectDescriptor.getBaseGraphicString().getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1External) {
            ASN1External aSN1External = (ASN1External)aSN1Primitive;
            stringBuffer.append(string2 + "External " + string3);
            String string7 = string2 + TAB;
            if (aSN1External.getDirectReference() != null) {
                stringBuffer.append(string7 + "Direct Reference: " + aSN1External.getDirectReference().getId() + string3);
            }
            if (aSN1External.getIndirectReference() != null) {
                stringBuffer.append(string7 + "Indirect Reference: " + aSN1External.getIndirectReference().toString() + string3);
            }
            if (aSN1External.getDataValueDescriptor() != null) {
                ASN1Dump._dumpAsString(string7, bl, aSN1External.getDataValueDescriptor(), stringBuffer);
            }
            stringBuffer.append(string7 + "Encoding: " + aSN1External.getEncoding() + string3);
            ASN1Dump._dumpAsString(string7, bl, aSN1External.getExternalContent(), stringBuffer);
        } else {
            stringBuffer.append(string2 + aSN1Primitive.toString() + string3);
        }
    }

    public static String dumpAsString(Object object) {
        return ASN1Dump.dumpAsString(object, false);
    }

    public static String dumpAsString(Object object, boolean bl) {
        ASN1Primitive aSN1Primitive;
        if (object instanceof ASN1Primitive) {
            aSN1Primitive = (ASN1Primitive)object;
        } else if (object instanceof ASN1Encodable) {
            aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
        } else {
            return "unknown object type " + object.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        ASN1Dump._dumpAsString("", bl, aSN1Primitive, stringBuffer);
        return stringBuffer.toString();
    }

    private static String dumpBinaryDataAsString(String string2, byte[] byArray) {
        String string3 = Strings.lineSeparator();
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string2 + TAB;
        stringBuffer.append(string3);
        for (int i = 0; i < byArray.length; i += 32) {
            if (byArray.length - i > 32) {
                stringBuffer.append(string2);
                stringBuffer.append(Strings.fromByteArray(Hex.encode(byArray, i, 32)));
                stringBuffer.append(TAB);
                stringBuffer.append(ASN1Dump.calculateAscString(byArray, i, 32));
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append(Strings.fromByteArray(Hex.encode(byArray, i, byArray.length - i)));
            for (int j = byArray.length - i; j != 32; ++j) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(TAB);
            stringBuffer.append(ASN1Dump.calculateAscString(byArray, i, byArray.length - i));
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String calculateAscString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i != n + n2; ++i) {
            if (byArray[i] < 32 || byArray[i] > 126) continue;
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }
}

