/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryImage
implements Comparable<LibraryImage> {
    private static Logger logger = LoggerFactory.getLogger(LibraryImage.class);
    private UUID guid;
    private String name;
    private String category;
    private String mimeType;
    private byte[] binaryData;
    private boolean imageProtected;
    private boolean complete = false;

    public LibraryImage() {
        this.guid = NXCommon.EMPTY_GUID;
        this.name = "";
        this.category = "Default";
        this.mimeType = "image/unknown";
    }

    public LibraryImage(UUID guid, String name, String category, String mimeType) {
        this.guid = guid;
        this.name = name;
        this.category = category;
        this.mimeType = mimeType != null ? mimeType : "image/unknown";
    }

    public LibraryImage(NXCPMessage msg, long baseId) {
        this.guid = msg.getFieldAsUUID(baseId);
        this.name = msg.getFieldAsString(baseId + 1L);
        this.category = msg.getFieldAsString(baseId + 2L);
        this.mimeType = msg.getFieldAsString(baseId + 3L);
        this.imageProtected = msg.getFieldAsBoolean(baseId + 4L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryImage(NXCPMessage msg, File imageFile) {
        this.guid = msg.getFieldAsUUID(222L);
        this.name = msg.getFieldAsString(20L);
        this.category = msg.getFieldAsString(75L);
        this.mimeType = msg.getFieldAsString(372L);
        this.imageProtected = msg.getFieldAsBoolean(370L);
        this.binaryData = new byte[(int)imageFile.length()];
        FileInputStream in = null;
        try {
            in = new FileInputStream(imageFile);
            ((InputStream)in).read(this.binaryData);
        }
        catch (Exception e) {
            logger.error("Failed to load image file", e);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                imageFile.delete();
            }
            catch (Exception exception) {}
        }
        this.complete = true;
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setField(222L, this.guid);
        msg.setField(20L, this.name);
        msg.setField(75L, this.category);
        msg.setField(372L, this.mimeType);
    }

    public UUID getGuid() {
        return this.guid;
    }

    public void setGuid(UUID guid) {
        this.guid = guid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(byte[] binaryData, String mimeType) {
        this.binaryData = binaryData;
        this.mimeType = mimeType != null ? mimeType : "image/unknown";
    }

    public boolean isProtected() {
        return this.imageProtected;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String toString() {
        return "LibraryImage [guid=" + String.valueOf(this.guid) + ", name=" + this.name + ", category=" + this.category + ", mimeType=" + this.mimeType + ", binaryData=" + (this.binaryData == null ? "[null]" : "[not null]") + ", imageProtected=" + this.imageProtected + ", complete=" + this.complete + "]";
    }

    @Override
    public int compareTo(LibraryImage o) {
        return this.name.compareToIgnoreCase(o.getName());
    }
}

