/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.util.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.commons.nullanalysis.NotNullByDefault;

public final class ApiLog {
    private ApiLog() {
    }

    public static Object logMethodInvocations(final Object delegate) {
        if (!Boolean.getBoolean(ApiLog.class.getName() + ".enable")) {
            return delegate;
        }
        Class<?> c = delegate.getClass();
        return Proxy.newProxyInstance(c.getClassLoader(), ApiLog.getAllInterfaces(c), new InvocationHandler(){

            @Override
            @NotNullByDefault(value=false)
            public Object invoke(Object proxy, Method method, Object[] arguments2) throws Throwable {
                Object returnValue;
                try {
                    returnValue = method.invoke(delegate, arguments2);
                }
                catch (InvocationTargetException ite) {
                    Throwable targetException = ite.getTargetException();
                    System.err.printf("%s.%s(%s) throws %s%n", delegate.getClass().getSimpleName(), method.getName(), ApiLog.truncate(Arrays.deepToString(arguments2)), targetException);
                    throw targetException;
                }
                System.err.printf("%s.%s(%s) => %s%n", delegate.getClass().getSimpleName(), method.getName(), ApiLog.truncate(Arrays.deepToString(arguments2)), ApiLog.truncate(String.valueOf(returnValue)));
                return returnValue;
            }
        });
    }

    protected static String truncate(String s) {
        return s.length() < 200 ? s : s.substring(0, 100) + "...";
    }

    private static Class<?>[] getAllInterfaces(Class<?> c) {
        HashSet result2 = new HashSet();
        ApiLog.getAllInterfaces(c, result2);
        return result2.toArray(new Class[result2.size()]);
    }

    private static void getAllInterfaces(Class<?> c, Set<Class<?>> result2) {
        if (c.isInterface()) {
            result2.add(c);
        }
        for (Class<?> i : c.getInterfaces()) {
            ApiLog.getAllInterfaces(i, result2);
        }
        Class<?> sc = c.getSuperclass();
        if (sc != null) {
            ApiLog.getAllInterfaces(sc, result2);
        }
    }
}

