/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OSPFInterfaceType {
    UNKNOWN(0, ""),
    BROADCAST(1, "BROADCAST"),
    NBMA(2, "NBMA"),
    POINT_TO_POINT(3, "PT-TO-PT"),
    POINT_TO_MULTIPOINT(4, "PT-TO-MP");

    private static Logger logger;
    private static Map<Integer, OSPFInterfaceType> lookupTable;
    private int value;
    private String text;

    private OSPFInterfaceType(int value, String text2) {
        this.value = value;
        this.text = text2;
    }

    public int getValue() {
        return this.value;
    }

    public String getText() {
        return this.text;
    }

    public static OSPFInterfaceType getByValue(int value) {
        OSPFInterfaceType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(OSPFInterfaceType.class);
        lookupTable = new HashMap<Integer, OSPFInterfaceType>();
        for (OSPFInterfaceType element : OSPFInterfaceType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

