/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RoutingProtocol {
    UNKNOWN(0),
    OTHER(1),
    LOCAL(2),
    NETMGMT(3),
    ICMP(4),
    EGP(5),
    GGP(6),
    HELLO(7),
    RIP(8),
    IS_IS(9),
    ES_IS(10),
    IGRP(11),
    BBN_SPF_IGP(12),
    OSPF(13),
    BGP(14),
    IDPR(15),
    EIGRP(16),
    DVMRP(17),
    RPL(18),
    DHCP(19);

    private static Logger logger;
    private static Map<Integer, RoutingProtocol> lookupTable;
    private int value;

    private RoutingProtocol(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RoutingProtocol getByValue(int value) {
        RoutingProtocol element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(RoutingProtocol.class);
        lookupTable = new HashMap<Integer, RoutingProtocol>();
        for (RoutingProtocol element : RoutingProtocol.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

