/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.io.StringWriter;
import java.util.Set;
import java.util.regex.Pattern;
import org.netxms.base.Glob;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Root(name="objectMenuFilter")
public class ObjectMenuFilter {
    public static final int REQUIRES_SNMP = 1;
    public static final int REQUIRES_AGENT = 2;
    public static final int REQUIRES_OID_MATCH = 4;
    public static final int REQUIRES_NODE_OS_MATCH = 8;
    public static final int REQUIRES_TEMPLATE_MATCH = 16;
    public static final int REQUIRES_WORKSTATION_OS_MATCH = 32;
    public static final int REQUIRES_CUSTOM_ATTRIBUTE_MATCH = 64;
    private static Logger logger = LoggerFactory.getLogger(ObjectMenuFilter.class);
    @Element(required=false, name="toolOS")
    public String toolNodeOS = "";
    @Element(required=false)
    public String toolWorkstationOS = "";
    @Element(required=false)
    public String toolTemplate = "";
    @Element(required=false)
    public String toolCustomAttributes = "";
    @Element(required=false)
    public String snmpOid = "";
    @Element(required=false)
    public int flags;

    public String createXml() {
        try {
            Persister serializer = new Persister();
            StringWriter writer = new StringWriter();
            serializer.write((Object)this, writer);
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            logger.warn("Exception during object menu filter serialization", e);
            return "";
        }
    }

    public boolean isApplicableForObject(AbstractObject object) {
        String[] substrings;
        boolean match;
        if (object instanceof AbstractNode) {
            int i;
            if ((this.flags & 1) != 0 && (((AbstractNode)object).getCapabilities() & 1L) == 0L) {
                return false;
            }
            if ((this.flags & 2) != 0 && (((AbstractNode)object).getCapabilities() & 2L) == 0L) {
                return false;
            }
            if ((this.flags & 4) != 0 && !Glob.matchIgnoreCase(this.snmpOid, ((AbstractNode)object).getSnmpOID())) {
                return false;
            }
            if ((this.flags & 8) != 0) {
                match = false;
                substrings = this.toolNodeOS.split(",");
                for (i = 0; i < substrings.length; ++i) {
                    if (!Pattern.matches(substrings[i], ((AbstractNode)object).getPlatformName())) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    return false;
                }
            }
            if ((this.flags & 0x20) != 0) {
                match = false;
                substrings = this.toolWorkstationOS.split(",");
                for (i = 0; i < substrings.length; ++i) {
                    if (!Pattern.matches(substrings[i], System.getProperty("os.name"))) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    return false;
                }
            }
        } else if ((this.flags & 0xF) != 0) {
            return false;
        }
        if ((this.flags & 0x10) != 0) {
            if (!(object instanceof AbstractNode) && !(object instanceof Cluster)) {
                return false;
            }
            match = false;
            substrings = this.toolTemplate.split(",");
            Set<AbstractObject> parents = object.getAllParents(8);
            for (AbstractObject parent : parents) {
                for (int i = 0; i < substrings.length; ++i) {
                    if (!Pattern.matches(substrings[i].trim(), parent.getObjectName().trim())) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if ((this.flags & 0x40) != 0) {
            match = false;
            substrings = this.toolCustomAttributes.split(",");
            for (String attr : object.getCustomAttributes().keySet()) {
                for (int i = 0; i < substrings.length; ++i) {
                    if (!Pattern.matches(substrings[i].trim(), attr.trim())) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                break;
            }
            if (!match) {
                return false;
            }
        }
        return true;
    }

    public void setFilter(String filterText, int filterType) {
        switch (filterType) {
            case 64: {
                this.toolCustomAttributes = filterText;
                break;
            }
            case 8: {
                this.toolNodeOS = filterText;
                break;
            }
            case 4: {
                this.snmpOid = filterText;
                break;
            }
            case 16: {
                this.toolTemplate = filterText;
                break;
            }
            case 32: {
                this.toolWorkstationOS = filterText;
                break;
            }
        }
    }
}

