/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.StringUtils;

abstract class RFC1522Codec {
    protected static final char SEP = '?';
    protected static final String POSTFIX = "?=";
    protected static final String PREFIX = "=?";
    protected final Charset charset;

    RFC1522Codec(Charset charset2) {
        this.charset = Objects.requireNonNull(charset2, "charset");
    }

    protected String decodeText(String text2) throws DecoderException, UnsupportedEncodingException {
        if (text2 == null) {
            return null;
        }
        if (!text2.startsWith(PREFIX) || !text2.endsWith(POSTFIX)) {
            throw new DecoderException("RFC 1522 violation: malformed encoded content");
        }
        int terminator = text2.length() - 2;
        int from = 2;
        int to = text2.indexOf(63, from);
        if (to == terminator) {
            throw new DecoderException("RFC 1522 violation: charset token not found");
        }
        String charset2 = text2.substring(from, to);
        if (charset2.isEmpty()) {
            throw new DecoderException("RFC 1522 violation: charset not specified");
        }
        from = to + 1;
        if ((to = text2.indexOf(63, from)) == terminator) {
            throw new DecoderException("RFC 1522 violation: encoding token not found");
        }
        String encoding = text2.substring(from, to);
        if (!this.getEncoding().equalsIgnoreCase(encoding)) {
            throw new DecoderException("This codec cannot decode " + encoding + " encoded content");
        }
        from = to + 1;
        to = text2.indexOf(63, from);
        byte[] data = StringUtils.getBytesUsAscii(text2.substring(from, to));
        data = this.doDecoding(data);
        return new String(data, charset2);
    }

    protected abstract byte[] doDecoding(byte[] var1) throws DecoderException;

    protected abstract byte[] doEncoding(byte[] var1) throws EncoderException;

    protected String encodeText(String text2, Charset charset2) throws EncoderException {
        if (text2 == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(PREFIX);
        buffer.append(charset2);
        buffer.append('?');
        buffer.append(this.getEncoding());
        buffer.append('?');
        buffer.append(StringUtils.newStringUsAscii(this.doEncoding(text2.getBytes(charset2))));
        buffer.append(POSTFIX);
        return buffer.toString();
    }

    protected String encodeText(String text2, String charsetName) throws EncoderException {
        if (text2 == null) {
            return null;
        }
        return this.encodeText(text2, Charset.forName(charsetName));
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }

    protected abstract String getEncoding();
}

