/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.NetworkService;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.modules.objects.views.helpers.NetworkServiceListLabelProvider;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class NetworkServiceListComparator
extends ViewerComparator {
    NetworkServiceListLabelProvider lp = null;

    public NetworkServiceListComparator(NetworkServiceListLabelProvider lp) {
        this.lp = lp;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        NetworkService ns1 = (NetworkService)e1;
        NetworkService ns2 = (NetworkService)e2;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        int result = 0;
        switch (column) {
            case 0: {
                result = Long.compare(ns1.getObjectId(), ns2.getObjectId());
                break;
            }
            case 1: {
                result = ns1.getObjectName().compareTo(ns2.getObjectName());
                break;
            }
            case 2: {
                result = StatusDisplayInfo.getStatusText((ObjectStatus)ns1.getStatus()).compareToIgnoreCase(StatusDisplayInfo.getStatusText((ObjectStatus)ns2.getStatus()));
                break;
            }
            case 3: {
                result = this.lp.types[ns1.getServiceType()].compareTo(this.lp.types[ns2.getServiceType()]);
                break;
            }
            case 4: {
                result = ns1.getIpAddress().getHostAddress().compareTo(ns2.getIpAddress().getHostAddress());
                break;
            }
            case 5: {
                result = ns1.getPort() - ns2.getPort();
                break;
            }
            case 6: {
                result = ns1.getRequest().compareTo(ns2.getRequest());
                break;
            }
            case 7: {
                result = ns1.getResponse().compareTo(ns2.getResponse());
                break;
            }
            case 8: {
                result = this.lp.getPollerName(ns1).compareTo(this.lp.getPollerName(ns2));
                break;
            }
            case 9: {
                result = ns1.getPollCount() - ns2.getPollCount();
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

