/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.views.helpers.LastValuesComparator;
import org.xnap.commons.i18n.I18n;

public class LastValuesComparator
extends ViewerComparator {
    private I18n i18n = LocalizationHelper.getI18n(LastValuesComparator.class);
    private NXCSession session = Registry.getSession();
    private boolean showErrors = true;

    public int compare(Viewer viewer, Object e1, Object e2) {
        TableColumn sortColumn = ((SortableTableViewer)viewer).getTable().getSortColumn();
        if (sortColumn == null) {
            return 0;
        }
        DciValue v1 = (DciValue)e1;
        DciValue v2 = (DciValue)e2;
        int result = 0;
        switch ((Integer)sortColumn.getData("ID")) {
            case 9: {
                result = v1.getComments().compareToIgnoreCase(v2.getComments());
                break;
            }
            case 2: {
                result = v1.getDescription().compareToIgnoreCase(v2.getDescription());
                break;
            }
            case 7: {
                result = this.getEventName(v1).compareToIgnoreCase(this.getEventName(v2));
                break;
            }
            case 1: {
                result = Long.compare(v1.getId(), v2.getId());
                break;
            }
            case 8: {
                result = this.getEventMessage(v1).compareToIgnoreCase(this.getEventMessage(v2));
                break;
            }
            case 0: {
                AbstractObject obj1 = Registry.getSession().findObjectById(v1.getNodeId());
                AbstractObject obj2 = Registry.getSession().findObjectById(v2.getNodeId());
                String name1 = obj1 != null ? obj1.getObjectName() : "[" + Long.toString(v1.getNodeId()) + "]";
                String name2 = obj2 != null ? obj2.getObjectName() : "[" + Long.toString(v2.getNodeId()) + "]";
                result = name1.compareToIgnoreCase(name2);
                break;
            }
            case 5: {
                result = v1.getUserTag().compareToIgnoreCase(v2.getUserTag());
                break;
            }
            case 4: {
                result = v1.getTimestamp().compareTo(v2.getTimestamp());
                break;
            }
            case 3: {
                result = this.compareValue(v1, v2);
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    public String getEventName(DciValue value) {
        Threshold threshold = value.getActiveThreshold();
        if (threshold == null) {
            return "";
        }
        return this.session.getEventName(threshold.getFireEvent());
    }

    public String getEventMessage(DciValue value) {
        Threshold threshold = value.getActiveThreshold();
        return threshold != null ? threshold.getLastEventMessage() : "";
    }

    private boolean isValidNumber(String value, DataType type) {
        try {
            switch (1.$SwitchMap$org$netxms$client$constants$DataType[type.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Long.parseLong(value);
                    break;
                }
                case 7: {
                    Double.parseDouble(value);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int compareValue(DciValue dci1, DciValue dci2) {
        String v2;
        DataType dt2;
        String v1;
        DataType dt1;
        if (this.showErrors && dci1.getErrorCount() > 0) {
            dt1 = DataType.STRING;
            v1 = this.i18n.tr("<< ERROR >>");
        } else if (dci1.getDcObjectType() == 2) {
            dt1 = DataType.STRING;
            v1 = this.i18n.tr("<< TABLE >>");
        } else {
            dt1 = dci1.getDataType();
            v1 = dci1.getValue();
        }
        if (this.showErrors && dci2.getErrorCount() > 0) {
            dt2 = DataType.STRING;
            v2 = this.i18n.tr("<< ERROR >>");
        } else if (dci2.getDcObjectType() == 2) {
            dt2 = DataType.STRING;
            v2 = this.i18n.tr("<< TABLE >>");
        } else {
            dt2 = dci2.getDataType();
            v2 = dci2.getValue();
        }
        boolean v1IsNumber = this.isValidNumber(v1, dt1);
        boolean v2IsNumber = this.isValidNumber(v2, dt2);
        if (v1IsNumber && v2IsNumber) {
            DataType dataType = DataType.getTypeForCompare((DataType)dt1, (DataType)dt2);
            switch (1.$SwitchMap$org$netxms$client$constants$DataType[dataType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return Long.compare(Long.parseLong(v1), Long.parseLong(v2));
                }
                case 7: {
                    return Double.compare(Double.parseDouble(v1), Double.parseDouble(v2));
                }
            }
            return v1.compareToIgnoreCase(v2);
        }
        if (v1IsNumber && !v2IsNumber) {
            return -1;
        }
        if (!v1IsNumber && v2IsNumber) {
            return 1;
        }
        return v1.compareToIgnoreCase(v2);
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }
}

