/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.windows;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.constants.Severity;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.BrandingManager;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.UIElementFilter;
import org.netxms.nxmc.base.menus.HelpMenuManager;
import org.netxms.nxmc.base.menus.UserMenuManager;
import org.netxms.nxmc.base.preferencepages.AppearancePage;
import org.netxms.nxmc.base.preferencepages.LanguagePage;
import org.netxms.nxmc.base.preferencepages.RegionalSettingsPage;
import org.netxms.nxmc.base.preferencepages.ThemesPage;
import org.netxms.nxmc.base.views.NonRestorableView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveSeparator;
import org.netxms.nxmc.base.views.PinLocation;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewFolder;
import org.netxms.nxmc.base.widgets.MessageArea;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.base.widgets.RoundedLabel;
import org.netxms.nxmc.base.widgets.ServerClock;
import org.netxms.nxmc.base.widgets.Spacer;
import org.netxms.nxmc.base.widgets.WelcomePage;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.keyboard.KeyStroke;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.preferencepages.AlarmPreferences;
import org.netxms.nxmc.modules.alarms.preferencepages.AlarmSounds;
import org.netxms.nxmc.modules.networkmaps.preferencepage.GeneralMapPreferences;
import org.netxms.nxmc.modules.objects.ObjectsPerspective;
import org.netxms.nxmc.modules.objects.preferencepages.ObjectsPreferences;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.ExternalWebBrowser;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class MainWindow
extends Window
implements MessageAreaHolder {
    private static final Logger logger = LoggerFactory.getLogger(MainWindow.class);
    private final I18n i18n = LocalizationHelper.getI18n(MainWindow.class);
    private Composite windowContent;
    private ToolBar mainMenu;
    private Composite headerArea;
    private MessageArea messageArea;
    private Composite mainArea;
    private Composite perspectiveArea;
    private List<Perspective> perspectives;
    private Perspective currentPerspective;
    private Perspective pinboardPerspective;
    private SashForm verticalSplitArea;
    private SashForm horizontalSplitArea;
    private ViewFolder leftPinArea;
    private ViewFolder rightPinArea;
    private ViewFolder bottomPinArea;
    private boolean verticalLayout;
    private boolean showServerClock;
    private Composite serverClockArea;
    private ServerClock serverClock;
    private RoundedLabel objectsOutOfSyncIndicator;
    private HeaderButton userMenuButton;
    private UserMenuManager userMenuManager;
    private HeaderButton helpMenuButton;
    private HelpMenuManager helpMenuManager;
    private List<Runnable> postOpenRunnables = new ArrayList();

    public MainWindow() {
        super((Shell)null);
        PreferenceStore ps = PreferenceStore.getInstance();
        this.verticalLayout = ps.getAsBoolean("Appearance.VerticalLayout", true);
        this.showServerClock = ps.getAsBoolean("Appearance.ShowServerClock", false);
        this.userMenuManager = new UserMenuManager();
        this.helpMenuManager = new HelpMenuManager();
    }

    protected int getShellStyle() {
        return 8;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        NXCSession session = Registry.getSession();
        shell.setText(String.format(this.i18n.tr("%s - %s"), BrandingManager.getClientProductName(), session.getUserName() + "@" + session.getServerAddress()));
        SessionListener sessionListener = n -> this.processSessionNotification(n);
        session.addListener(sessionListener);
        shell.setMaximized(true);
        shell.setFullScreen(true);
        shell.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    void savePinArea(PreferenceStore ps, PinLocation location, ViewFolder pinArea) {
        if (pinArea == null) {
            return;
        }
        Memento m = new Memento();
        pinArea.saveState(m);
        ps.set(PreferenceStore.serverProperty((String)location.name()), m);
    }

    protected ShellListener getShellListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void addPostOpenRunnable(Runnable postOpenRunnable) {
        this.postOpenRunnables.add(postOpenRunnable);
    }

    private void showWelcomePage() {
        String v;
        NXCSession session = Registry.getSession();
        PreferenceStore ps = PreferenceStore.getInstance();
        if (ps.getAsBoolean("WelcomePage.Disabled", !session.getClientConfigurationHintAsBoolean("EnableWelcomePage", true))) {
            return;
        }
        String serverVersion = session.getServerVersion();
        int dotCount = 0;
        for (int i = 0; i < serverVersion.length(); ++i) {
            char ch = serverVersion.charAt(i);
            if (ch == '-') {
                serverVersion = serverVersion.substring(0, i);
                break;
            }
            if (ch != '.' || ++dotCount != 3) continue;
            serverVersion = serverVersion.substring(0, i);
            break;
        }
        if (serverVersion.equals(v = ps.getAsString("WelcomePage.LastDisplayedVersion"))) {
            return;
        }
        WelcomePage welcomePage = new WelcomePage(this.mainArea, 0, serverVersion);
        welcomePage.setSize(this.mainArea.getSize());
        welcomePage.moveAbove(null);
    }

    protected Layout getLayout() {
        return new FillLayout();
    }

    protected Control createContents(Composite parent) {
        NXCSession session = Registry.getSession();
        Font perspectiveSwitcherFont = ThemeEngine.getFont((String)"Window.PerspectiveSwitcher");
        this.windowContent = new Composite(parent, 0);
        GridLayout windowContentLayout = new GridLayout();
        windowContentLayout.marginWidth = 0;
        windowContentLayout.marginHeight = 0;
        windowContentLayout.verticalSpacing = 0;
        this.windowContent.setLayout((Layout)windowContentLayout);
        Color headerBackgroundColor = new Color((Device)parent.getDisplay(), BrandingManager.getAppHeaderBackground());
        Color headerForegroundColor = ThemeEngine.getForegroundColor((String)"Window.Header");
        this.headerArea = new Composite(this.windowContent, 0);
        this.headerArea.setBackground(headerBackgroundColor);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.headerArea.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 15;
        this.headerArea.setLayout((Layout)layout);
        Label appLogo = new Label(this.headerArea, 0x1000000);
        appLogo.setBackground(headerBackgroundColor);
        appLogo.setImage(BrandingManager.getAppHeaderImage().createImage());
        gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalIndent = 8;
        appLogo.setLayoutData((Object)gd);
        Label title = new Label(this.headerArea, 16384);
        title.setBackground(headerBackgroundColor);
        title.setForeground(headerForegroundColor);
        title.setData("org.eclipse.rap.rwt.customVariant", (Object)"MainWindowHeaderBold");
        title.setText(BrandingManager.getProductName().toUpperCase());
        Label filler = new Label(this.headerArea, 0x1000000);
        filler.setBackground(headerBackgroundColor);
        filler.setLayoutData((Object)new GridData(4, 4, true, false));
        this.objectsOutOfSyncIndicator = new RoundedLabel(this.headerArea);
        this.objectsOutOfSyncIndicator.setData("org.eclipse.rap.rwt.customVariant", (Object)"MainWindowHeaderNormal");
        this.objectsOutOfSyncIndicator.setLabelForeground(null, headerForegroundColor);
        this.objectsOutOfSyncIndicator.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.serverClockArea = new Composite(this.headerArea, 0);
        this.serverClockArea.setBackground(headerBackgroundColor);
        this.serverClockArea.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        this.serverClockArea.setLayout((Layout)new FillLayout());
        if (this.showServerClock) {
            this.createServerClockWidget();
        }
        new Spacer(this.headerArea, 32);
        RoundedLabel serverName = new RoundedLabel(this.headerArea);
        serverName.setData("org.eclipse.rap.rwt.customVariant", (Object)"MainWindowHeaderNormal");
        serverName.setLabelForeground(null, headerForegroundColor);
        serverName.setText(session.getServerName());
        serverName.setToolTipText(this.i18n.tr("Server name"));
        RGB serverColor = ColorConverter.parseColorDefinition((String)session.getServerColor());
        if (serverColor != null) {
            serverName.setLabelBackground(new Color((Device)serverName.getDisplay(), serverColor));
        }
        new Spacer(this.headerArea, 32);
        this.userMenuButton = new HeaderButton(this.headerArea, "icons/main-window/user.png", this.i18n.tr("User properties"), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        Label userInfo = new Label(this.headerArea, 16384);
        userInfo.setBackground(headerBackgroundColor);
        userInfo.setForeground(headerForegroundColor);
        userInfo.setData("org.eclipse.rap.rwt.customVariant", (Object)"MainWindowHeaderNormal");
        userInfo.setText(session.getUserName() + "@" + session.getServerAddress());
        userInfo.setToolTipText(this.i18n.tr("Login name and server address"));
        new Spacer(this.headerArea, 32);
        new HeaderButton(this.headerArea, "icons/main-window/preferences.png", this.i18n.tr("Client preferences"), () -> this.showPreferences());
        this.helpMenuButton = new HeaderButton(this.headerArea, "icons/main-window/help.png", BrandingManager.isExtendedHelpMenuEnabled() ? this.i18n.tr("Help") : this.i18n.tr("Open user manual"), () -> {
            if (BrandingManager.isExtendedHelpMenuEnabled()) {
                Rectangle bounds = this.helpMenuButton.getBounds();
                this.showMenu((MenuManager)this.helpMenuManager, this.headerArea.toDisplay(new Point(bounds.x, bounds.y + bounds.height + 2)));
            } else {
                ExternalWebBrowser.open((String)BrandingManager.getAdministratorGuideURL());
            }
        });
        new HeaderButton(this.headerArea, "icons/main-window/about.png", this.i18n.tr("About NetXMS Management Client"), () -> BrandingManager.createAboutDialog((Shell)this.getShell()).open());
        new Spacer(this.headerArea, 8);
        this.mainArea = new Composite(this.windowContent, 0);
        this.mainArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainArea.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite mainAreaInner = new Composite(this.mainArea, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = this.verticalLayout ? 2 : 1;
        mainAreaInner.setLayout((Layout)layout);
        Composite menuArea = new Composite(mainAreaInner, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.verticalLayout ? 1 : 2;
        menuArea.setLayout((Layout)layout);
        gd = new GridData();
        if (this.verticalLayout) {
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
            gd.verticalSpan = 2;
        } else {
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
        menuArea.setLayoutData((Object)gd);
        this.mainMenu = new ToolBar(menuArea, 0x820040 | (this.verticalLayout ? 512 : 256));
        this.mainMenu.setFont(perspectiveSwitcherFont);
        gd = new GridData();
        if (this.verticalLayout) {
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        } else {
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
        this.mainMenu.setLayoutData((Object)gd);
        this.messageArea = new MessageArea(mainAreaInner, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.messageArea.setLayoutData((Object)gd);
        this.horizontalSplitArea = new SashForm(mainAreaInner, 256);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.horizontalSplitArea.setLayoutData((Object)gd);
        this.verticalSplitArea = new SashForm((Composite)this.horizontalSplitArea, 512);
        this.perspectiveArea = new Composite((Composite)this.verticalSplitArea, 0);
        this.perspectiveArea.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setupPerspectiveSwitcher();
        Display display = parent.getDisplay();
        display.addFilter(1, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.switchToPerspective("pinboard");
        PreferenceStore ps = PreferenceStore.getInstance();
        this.switchToPerspective(ps.getAsString(PreferenceStore.serverProperty((String)"MainWindow.CurrentPerspective", (NXCSession)session)));
        this.restorePinArea(ps, PinLocation.BOTTOM);
        this.restorePinArea(ps, PinLocation.LEFT);
        this.restorePinArea(ps, PinLocation.RIGHT);
        String motd = session.getMessageOfTheDay();
        if (motd != null && !motd.isEmpty()) {
            this.addMessage(0, session.getMessageOfTheDay());
        }
        return this.windowContent;
    }

    public void restorePinArea(PreferenceStore ps, PinLocation location) {
        Memento memento = ps.getAsMemento(PreferenceStore.serverProperty((String)location.name()));
        List views = memento.getAsStringList("ViewFolder.Views");
        for (String id : views) {
            Memento viewConfig = memento.getAsMemento(id + ".state");
            View v = null;
            try {
                Class<?> widgetClass = Class.forName(viewConfig.getAsString("class"));
                Constructor<?> c = widgetClass.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                v = (View)c.newInstance(new Object[0]);
                if (v == null) continue;
                v.restoreState(viewConfig);
                this.pinView(v, location);
            }
            catch (Exception e) {
                this.pinView((View)new NonRestorableView(e, v != null ? v.getFullName() : id), location);
                logger.error("Cannot restore pinned view", (Throwable)e);
            }
        }
    }

    private void processKeyDownEvent(int stateMask, int keyCode) {
        if (keyCode == 131072 || keyCode == 262144 || keyCode == 131072 || keyCode == 65536 || keyCode == 0x400000) {
            return;
        }
        KeyStroke ks = new KeyStroke(stateMask, keyCode);
        boolean processed = false;
        for (Perspective p : this.perspectives) {
            if (!ks.equals((Object)p.getKeyboardShortcut())) continue;
            processed = true;
            this.getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            break;
        }
        if (!processed && this.currentPerspective != null) {
            this.currentPerspective.processKeyStroke(ks);
        }
    }

    private void resizePerspectiveAreaContent() {
        for (Control c : this.perspectiveArea.getChildren()) {
            if (!c.isVisible()) continue;
            c.setSize(this.perspectiveArea.getSize());
            break;
        }
    }

    private void setupPerspectiveSwitcher() {
        boolean darkTheme = WidgetHelper.isSystemDarkTheme();
        ArrayList<Image> perspectiveIcons = darkTheme ? new ArrayList<Image>() : null;
        UIElementFilter filter = (UIElementFilter)Registry.getSingleton(UIElementFilter.class);
        NXCSession session = Registry.getSession();
        this.perspectives = Registry.getPerspectives().stream().filter(p -> p.isValidForSession(session) && filter.isVisible(UIElementFilter.ElementType.PERSPECTIVE, p.getId())).toList();
        for (Perspective p2 : this.perspectives) {
            KeyStroke shortcut;
            if (p2 instanceof PerspectiveSeparator) {
                new ToolItem(this.mainMenu, 2);
                continue;
            }
            p2.bindToWindow((Window)this);
            ToolItem item = new ToolItem(this.mainMenu, 16);
            item.setData("PerspectiveId", (Object)p2.getId());
            if (darkTheme) {
                Image image = new Image((Device)this.getShell().getDisplay(), ColorConverter.invertImageColors((ImageData)p2.getImage().getImageData()));
                item.setImage(image);
                perspectiveIcons.add(image);
            } else {
                item.setImage(p2.getImage());
            }
            if (!this.verticalLayout) {
                item.setText(p2.getName());
            }
            item.setToolTipText((String)((shortcut = p2.getKeyboardShortcut()) != null ? p2.getName() + "\t" + shortcut.toString() : p2.getName()));
            item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            if (!p2.getId().equals("pinboard")) continue;
            this.pinboardPerspective = p2;
        }
        if (darkTheme) {
            this.getShell().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void switchToPerspective(Perspective p) {
        logger.debug("Switching to perspective " + p.getName());
        if (this.currentPerspective != null) {
            this.currentPerspective.hide();
        }
        this.currentPerspective = p;
        this.currentPerspective.show(this.perspectiveArea);
        this.resizePerspectiveAreaContent();
        for (ToolItem item : this.mainMenu.getItems()) {
            Object id = item.getData("PerspectiveId");
            if (id == null) continue;
            item.setSelection(p.getId().equals(id));
        }
    }

    public void switchToPerspective(String id) {
        for (Perspective p : this.perspectives) {
            if (!p.getId().equals(id)) continue;
            this.switchToPerspective(p);
            break;
        }
    }

    public void pinView(View view, PinLocation location) {
        logger.debug("Request to pin view with GlobalID=" + view.getGlobalId() + " at location=" + String.valueOf(location));
        switch (11.$SwitchMap$org$netxms$nxmc$base$views$PinLocation[location.ordinal()]) {
            case 1: {
                this.bottomPinArea = this.pinViewToArea(view, this.bottomPinArea, this.verticalSplitArea, false);
                break;
            }
            case 2: {
                this.leftPinArea = this.pinViewToArea(view, this.leftPinArea, this.horizontalSplitArea, true);
                break;
            }
            case 3: {
                this.pinboardPerspective.addMainView(view, true, true);
                break;
            }
            case 4: {
                this.rightPinArea = this.pinViewToArea(view, this.rightPinArea, this.horizontalSplitArea, false);
            }
        }
    }

    private ViewFolder pinViewToArea(View view, ViewFolder pinArea, SashForm splitter, boolean moveToTop) {
        if (pinArea == null || pinArea.isDisposed()) {
            int[] weights = splitter.getWeights();
            pinArea = new ViewFolder((Window)this, null, (Composite)splitter, true, false, false, false);
            pinArea.setAllViewsAsCloseable(true);
            pinArea.setUseGlobalViewId(true);
            pinArea.setDisposeWhenEmpty(true);
            if (moveToTop) {
                pinArea.moveAbove(null);
                int[] nweights = new int[weights.length + 1];
                int total = 0;
                for (int w : weights) {
                    total += w;
                }
                nweights[0] = 3 * total / 7;
                System.arraycopy(weights, 0, nweights, 1, weights.length);
                weights = nweights;
            } else {
                weights = Arrays.copyOf(weights, weights.length + 1);
                int total = 0;
                for (int w : weights) {
                    total += w;
                }
                weights[weights.length - 1] = 3 * total / 7;
            }
            splitter.setWeights(weights);
            this.windowContent.layout(true, true);
        }
        pinArea.addView(view, true, true);
        return pinArea;
    }

    private void showPreferences() {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("appearance", (IPreferencePage)new AppearancePage()));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("alarm", (IPreferencePage)new AlarmPreferences()));
        pm.addTo("alarm", (IPreferenceNode)new PreferenceNode("alarmSounds", (IPreferencePage)new AlarmSounds()));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("language", (IPreferencePage)new LanguagePage()));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("networkMap", (IPreferencePage)new GeneralMapPreferences()));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("objects", (IPreferencePage)new ObjectsPreferences()));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("regionalSettings", (IPreferencePage)new RegionalSettingsPage()));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("themes", (IPreferencePage)new ThemesPage()));
        10 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        dlg.open();
        this.showServerClock = PreferenceStore.getInstance().getAsBoolean("Appearance.ShowServerClock", false);
        if (this.showServerClock && this.serverClock == null) {
            this.createServerClockWidget();
            this.headerArea.layout(true);
        } else if (!this.showServerClock && this.serverClock != null) {
            for (Control c : this.serverClockArea.getChildren()) {
                c.dispose();
            }
            this.serverClock.dispose();
            this.serverClock = null;
            this.headerArea.layout(true);
        }
    }

    private void createServerClockWidget() {
        new Spacer(this.serverClockArea, 27, null);
        this.serverClock = new ServerClock(this.serverClockArea, 0);
        this.serverClock.setBackground(this.serverClockArea.getBackground());
        this.serverClock.setForeground(ThemeEngine.getForegroundColor((String)"Window.Header"));
        this.serverClock.setDisplayFormatChangeListener(() -> this.headerArea.layout());
    }

    private void showMenu(MenuManager menuManager, Point location) {
        Menu menu = menuManager.createContextMenu((Control)this.getShell());
        menu.setLocation(location);
        menu.setVisible(true);
    }

    public int addMessage(int level, String text) {
        return this.messageArea.addMessage(level, text);
    }

    public int addMessage(int level, String text, boolean sticky) {
        return this.messageArea.addMessage(level, text);
    }

    public int addMessage(int level, String text, boolean sticky, String buttonText, Runnable action) {
        return this.messageArea.addMessage(level, text, sticky, buttonText, action);
    }

    public void deleteMessage(int id) {
        this.messageArea.deleteMessage(id);
    }

    public void clearMessages() {
        this.messageArea.clearMessages();
    }

    public static void switchToObject(long objectId, long dciId) {
        Perspective p;
        AbstractObject object = Registry.getSession().findObjectById(objectId);
        if (object == null) {
            return;
        }
        Iterator iterator = Registry.getPerspectives().iterator();
        while (!(!iterator.hasNext() || (p = (Perspective)iterator.next()) instanceof ObjectsPerspective && ((ObjectsPerspective)p).showObject(object, dciId))) {
        }
    }

    private void processSessionNotification(SessionNotification n) {
        if (n.getCode() == 1038) {
            this.getShell().getDisplay().asyncExec(() -> {
                this.objectsOutOfSyncIndicator.setText(this.i18n.tr("OBJECTS OUT OF SYNC"));
                this.objectsOutOfSyncIndicator.setLabelBackground(StatusDisplayInfo.getStatusBackgroundColor((Severity)Severity.MINOR));
                this.headerArea.layout(true);
            });
        } else if (n.getCode() == 1052) {
            this.getShell().getDisplay().asyncExec(() -> {
                this.objectsOutOfSyncIndicator.setText("");
                this.objectsOutOfSyncIndicator.setLabelBackground(null);
                this.headerArea.layout(true);
            });
        }
    }

    static /* synthetic */ boolean access$000(MainWindow x0) {
        return x0.canHandleShellCloseEvent();
    }

    static /* synthetic */ void access$100(MainWindow x0) {
        x0.handleShellCloseEvent();
    }
}

