/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditableComboBoxCellEditor
extends CellEditor {
    public static final int DROP_DOWN_ON_MOUSE_ACTIVATION = 1;
    public static final int DROP_DOWN_ON_KEY_ACTIVATION = 2;
    public static final int DROP_DOWN_ON_PROGRAMMATIC_ACTIVATION = 4;
    public static final int DROP_DOWN_ON_TRAVERSE_ACTIVATION = 8;
    private int activationStyle = 0;
    private ArrayList<String> items = new ArrayList();
    String selection;
    CCombo comboBox;
    private static final int defaultStyle = 0;

    public EditableComboBoxCellEditor() {
        this.setStyle(0);
    }

    public EditableComboBoxCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public EditableComboBoxCellEditor(Composite parent, String[] items, int style) {
        super(parent, style);
        this.setItems(items);
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        Collections.addAll(this.items, items);
        this.populateComboBoxItems();
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.populateComboBoxItems();
        this.comboBox.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.comboBox.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.comboBox.addTraverseListener((TraverseListener & Serializable)e -> {
            if (e.detail == 2 || e.detail == 4) {
                e.doit = false;
            }
        });
        String[] cancelKeys = new String[]{"ESC", "ENTER"};
        this.comboBox.setData("org.eclipse.rap.rwt.cancelKeys", (Object)cancelKeys);
        this.comboBox.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.comboBox;
    }

    protected Object doGetValue() {
        return this.selection;
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        int i;
        Assert.isTrue((this.comboBox != null && value instanceof String ? 1 : 0) != 0);
        this.selection = (String)value;
        for (i = 0; i < this.items.size() && !((String)this.items.get(i)).equals(this.selection); ++i) {
        }
        if (i == this.items.size()) {
            this.items.add(this.selection);
            this.comboBox.add(this.selection, i);
        }
        this.comboBox.select(i);
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            for (int i = 0; i < this.items.size(); ++i) {
                this.comboBox.add((String)this.items.get(i), i);
            }
            this.setValueValid(true);
            this.selection = (String)this.items.get(0);
        }
    }

    void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getText();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\r') {
            this.applyEditorValueAndDeactivate();
        }
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        super.activate(activationEvent);
        if (this.activationStyle != 0) {
            boolean dropDown = false;
            if ((activationEvent.eventType == 2 || activationEvent.eventType == 3) && (this.activationStyle & 1) != 0) {
                dropDown = true;
            } else if (activationEvent.eventType == 1 && (this.activationStyle & 2) != 0) {
                dropDown = true;
            } else if (activationEvent.eventType == 4 && (this.activationStyle & 4) != 0) {
                dropDown = true;
            } else if (activationEvent.eventType == 5 && (this.activationStyle & 8) != 0) {
                dropDown = true;
            }
            if (dropDown) {
                this.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public void setActivationStyle(int activationStyle) {
        this.activationStyle = activationStyle;
    }
}

