/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.events.AlarmCategory;
import org.netxms.ui.eclipse.alarmviewer.dialogs.AlarmCategorySelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class AlarmCategorySelector
extends AbstractSelector {
    private List<Long> categoryId;

    public AlarmCategorySelector(Composite parent, int style) {
        super(parent, style, 0);
        this.setText("<none>");
        this.categoryId = new ArrayList<Long>(0);
    }

    protected void selectionButtonHandler() {
        AlarmCategorySelectionDialog dlg = new AlarmCategorySelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            this.categoryId.clear();
            AlarmCategory[] categories = dlg.getSelectedCategories();
            if (categories != null && categories.length > 0) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < categories.length) {
                    this.categoryId.add(categories[i].getId());
                    sb.append(String.valueOf(categories[i].getName()) + "; ");
                    ++i;
                }
                this.setText(sb.toString());
            } else {
                this.setText("<none>");
            }
        }
    }

    public List<Long> getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(List<Long> categoryId) {
        if (this.categoryId.equals(categoryId)) {
            return;
        }
        if (categoryId != null && !categoryId.isEmpty()) {
            if (categoryId.get(0) == 0L) {
                this.setText("<none>");
            } else {
                List categories = ConsoleSharedData.getSession().findMultipleAlarmCategories(categoryId);
                if (categories != null) {
                    StringBuilder sb = new StringBuilder();
                    this.categoryId.clear();
                    for (AlarmCategory c : categories) {
                        sb.append(String.valueOf(c.getName()) + ";");
                        this.categoryId.add(c.getId());
                    }
                    this.setText(sb.toString());
                } else {
                    this.setText("<unknown>");
                }
            }
        } else {
            this.setText("<none>");
        }
        this.fireModifyListeners();
    }

    protected void clearButtonHandler() {
        if (this.categoryId == null || this.categoryId.isEmpty()) {
            return;
        }
        this.setText("<none>");
        this.fireModifyListeners();
    }

    protected String getSelectionButtonToolTip() {
        return "Select category";
    }
}

