/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets.helpers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.netxms.ui.eclipse.perfview.widgets.helpers.CellSelectionHighlighter;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class CellSelectionManager {
    private CellNavigationStrategy navigationStrategy;
    private SortableTableViewer viewer;
    private ViewerCell focusCell;
    private Set<ViewerCell> selectedCells = new HashSet<ViewerCell>();
    private CellSelectionHighlighter cellHighlighter;
    private DisposeListener itemDeletionListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            CellSelectionManager.this.setFocusCell(null, true);
        }
    };

    public CellSelectionManager(SortableTableViewer viewer) {
        this.viewer = viewer;
        this.cellHighlighter = new CellSelectionHighlighter(viewer, this);
        this.navigationStrategy = new CellNavigationStrategy();
        this.hookListener(viewer);
    }

    private void handleMouseDown(Event event) {
        ViewerCell cell = this.viewer.getCell(new Point(event.x, event.y));
        if (cell != null) {
            if (!cell.equals((Object)this.focusCell)) {
                this.setFocusCell(cell, (event.stateMask & 0x40000) == 0);
            } else if ((event.stateMask & 0x40000) != 0) {
                this.setFocusCell(cell, false);
            }
        }
    }

    private void handleKeyDown(Event event) {
        ViewerCell tmp = null;
        if (this.navigationStrategy.isCollapseEvent((ColumnViewer)this.viewer, this.focusCell, event)) {
            this.navigationStrategy.collapse((ColumnViewer)this.viewer, this.focusCell, event);
        } else if (this.navigationStrategy.isExpandEvent((ColumnViewer)this.viewer, this.focusCell, event)) {
            this.navigationStrategy.expand((ColumnViewer)this.viewer, this.focusCell, event);
        } else if (this.navigationStrategy.isNavigationEvent((ColumnViewer)this.viewer, event) && (tmp = this.navigationStrategy.findSelectedCell((ColumnViewer)this.viewer, this.focusCell, event)) != null && !tmp.equals((Object)this.focusCell)) {
            this.setFocusCell(tmp, true);
        }
        if (this.navigationStrategy.shouldCancelEvent((ColumnViewer)this.viewer, event)) {
            event.doit = false;
        }
    }

    private void handleSelection(Event event) {
        if ((event.detail & 0x20) == 0 && this.focusCell != null && this.focusCell.getItem() != event.item && event.item != null && !event.item.isDisposed()) {
            ViewerRow row = this.viewer.getViewerRowFromItem(event.item);
            Assert.isNotNull((Object)row, (String)"Internal Structure invalid. Row item has no row ViewerRow assigned");
            ViewerCell tmp = row.getCell(this.focusCell.getColumnIndex());
            if (!this.focusCell.equals((Object)tmp)) {
                this.setFocusCell(tmp, true);
            }
        }
    }

    private void handleFocusIn(Event event) {
        if (this.focusCell == null) {
            this.setFocusCell(this.getInitialFocusCell(), true);
        }
    }

    private ViewerCell getInitialFocusCell() {
        Table table = this.viewer.getTable();
        if (!table.isDisposed() && table.getItemCount() > 0 && !table.getItem(table.getTopIndex()).isDisposed()) {
            ViewerRow aViewerRow = this.viewer.getViewerRowFromItem((Widget)table.getItem(table.getTopIndex()));
            if (table.getColumnCount() == 0) {
                return aViewerRow.getCell(0);
            }
            Rectangle clientArea = table.getClientArea();
            int i = 0;
            while (i < table.getColumnCount()) {
                if (this.columnInVisibleArea(clientArea, aViewerRow, i)) {
                    return aViewerRow.getCell(i);
                }
                ++i;
            }
        }
        return null;
    }

    private boolean columnInVisibleArea(Rectangle clientArea, ViewerRow row, int colIndex) {
        return row.getBounds((int)colIndex).x >= clientArea.x;
    }

    private void hookListener(SortableTableViewer viewer) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        CellSelectionManager.this.handleMouseDown(event);
                        break;
                    }
                    case 1: {
                        CellSelectionManager.this.handleKeyDown(event);
                        break;
                    }
                    case 13: {
                        CellSelectionManager.this.handleSelection(event);
                        break;
                    }
                    case 15: {
                        CellSelectionManager.this.handleFocusIn(event);
                    }
                }
            }
        };
        viewer.getControl().addListener(3, listener);
        viewer.getControl().addListener(1, listener);
        viewer.getControl().addListener(13, listener);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                event.getSelection().isEmpty();
            }
        });
        viewer.getControl().addListener(15, listener);
    }

    public ViewerCell getFocusCell() {
        return this.focusCell;
    }

    void setFocusCell(ViewerCell focusCell, boolean clearSelection) {
        if (clearSelection) {
            this.selectedCells.clear();
            this.viewer.getTable().deselectAll();
            if (focusCell != null) {
                this.selectedCells.add(focusCell);
                this.viewer.getTable().select(this.viewer.getTable().indexOf((TableItem)focusCell.getViewerRow().getItem()));
            }
        } else if (focusCell != null) {
            if (this.selectedCells.contains(focusCell)) {
                this.selectedCells.remove(focusCell);
                ViewerRow row = focusCell.getViewerRow();
                boolean removeRowSelection = true;
                for (ViewerCell c : this.selectedCells) {
                    if (!row.equals((Object)c.getViewerRow())) continue;
                    removeRowSelection = false;
                    break;
                }
                if (removeRowSelection) {
                    this.viewer.getTable().deselect(this.viewer.getTable().indexOf((TableItem)row.getItem()));
                } else {
                    this.viewer.getTable().select(this.viewer.getTable().indexOf((TableItem)row.getItem()));
                }
            } else {
                this.selectedCells.add(focusCell);
                this.viewer.getTable().select(this.viewer.getTable().indexOf((TableItem)focusCell.getViewerRow().getItem()));
            }
        }
        ViewerCell oldCell = this.focusCell;
        if (this.focusCell != null && !this.focusCell.getItem().isDisposed()) {
            this.focusCell.getItem().removeDisposeListener(this.itemDeletionListener);
        }
        this.focusCell = focusCell;
        if (this.focusCell != null && !this.focusCell.getItem().isDisposed()) {
            this.focusCell.getItem().addDisposeListener(this.itemDeletionListener);
        }
        if (focusCell != null) {
            focusCell.scrollIntoView();
        }
        this.cellHighlighter.focusCellChanged(focusCell, oldCell);
        this.viewer.getControl().getAccessible().setFocus(-1);
    }

    protected boolean isCellSelected(ViewerCell cell) {
        return this.selectedCells.contains(cell);
    }

    public ViewerCell[] getSelectedCells() {
        return this.selectedCells.toArray(new ViewerCell[this.selectedCells.size()]);
    }
}

