/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.helpers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class NodeListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private NXCSession session = ConsoleSharedData.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        AbstractNode node = (AbstractNode)element;
        switch (columnIndex) {
            case 6: {
                return node.getSystemDescription();
            }
            case 0: {
                return Long.toString(node.getObjectId());
            }
            case 1: {
                return node.getNameWithAlias();
            }
            case 7: {
                return StatusDisplayInfo.getStatusText((ObjectStatus)node.getStatus());
            }
            case 2: {
                return node.getPrimaryIP().isValidUnicastAddress() ? node.getPrimaryIP().getHostAddress() : null;
            }
            case 4: {
                return node.getPlatformName();
            }
            case 5: {
                return node.getAgentVersion();
            }
            case 3: {
                Rack rack;
                if (node.getPhysicalContainerId() != 0L && (rack = (Rack)this.session.findObjectById(node.getPhysicalContainerId(), Rack.class)) != null) {
                    Messages.get();
                    return String.format(Messages.GeneralInfo_Units, rack.getObjectName(), rack.isTopBottomNumbering() ? node.getRackPosition() : node.getRackPosition() - node.getRackHeight() + 1, rack.isTopBottomNumbering() ? node.getRackPosition() + node.getRackHeight() - 1 : node.getRackPosition());
                }
                return "";
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        AbstractNode node = (AbstractNode)element;
        switch (columnIndex) {
            case 7: {
                return StatusDisplayInfo.getStatusColor((ObjectStatus)node.getStatus());
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

