/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Zone;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.ZoneSNMPCredentials;
import org.netxms.nxmc.modules.serverconfig.dialogs.EditSnmpUsmCredentialsDialog;
import org.netxms.nxmc.modules.serverconfig.views.helpers.SnmpUsmCredentialsLabelProvider;
import org.xnap.commons.i18n.I18n;

public class ZoneSNMPCredentials
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(ZoneSNMPCredentials.class);
    private Zone zone;
    private List<String> communities;
    private List<SnmpUsmCredential> usmCredentials;
    private List<Integer> ports;
    private TableViewer communityList;
    private Button commMoveUpButton;
    private Button commMoveDownButton;
    private Button commAddButton;
    private Button commDeleteButton;
    private SortableTableViewer usmCredentialList;
    private Button usmMoveUpButton;
    private Button usmMoveDownButton;
    private Button usmAddButton;
    private Button usmEditButton;
    private Button usmDeleteButton;
    private TableViewer portList;
    private Button portMoveUpButton;
    private Button portMoveDownButton;
    private Button portAddButton;
    private Button portDeleteButton;
    private int modified = 0;

    public ZoneSNMPCredentials(AbstractObject object) {
        super(LocalizationHelper.getI18n(ZoneSNMPCredentials.class).tr("SNMP Credentials"), object);
    }

    public String getId() {
        return "zoneCommunications.snmpCredentials";
    }

    public String getParentId() {
        return "zoneCommunications";
    }

    public boolean isVisible() {
        return this.object instanceof Zone;
    }

    protected Control createContents(Composite parent) {
        this.zone = (Zone)this.object;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.createCommunitySection(dialogArea);
        this.createPortSection(dialogArea);
        this.createUSMCredentialsSection(dialogArea);
        this.loadConfig();
        return dialogArea;
    }

    private void createCommunitySection(Composite dialogArea) {
        Group clientArea = new Group(dialogArea, 0);
        clientArea.setText("Community strings");
        clientArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        this.communityList = new TableViewer((Composite)clientArea, 67586);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        this.communityList.getTable().setLayoutData((Object)gd);
        this.communityList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonsLeft = new Composite((Composite)clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gd);
        this.commMoveUpButton = new Button(buttonsLeft, 8);
        this.commMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.commMoveUpButton.setLayoutData((Object)rd);
        this.commMoveUpButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.commMoveDownButton = new Button(buttonsLeft, 8);
        this.commMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.commMoveDownButton.setLayoutData((Object)rd);
        this.commMoveDownButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttonsRight = new Composite((Composite)clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gd);
        this.commAddButton = new Button(buttonsRight, 8);
        this.commAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.commAddButton.setLayoutData((Object)rd);
        this.commAddButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.commDeleteButton = new Button(buttonsRight, 8);
        this.commDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.commDeleteButton.setLayoutData((Object)rd);
        this.commDeleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.communityList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadConfig() {
        NXCSession session = Registry.getSession();
        6 job = new /* Unavailable Anonymous Inner Class!! */;
        job.start();
    }

    private void setModified(int configId) {
        this.modified |= configId;
    }

    private void addCommunity() {
        InputDialog dlg = new InputDialog(this.getShell(), this.i18n.tr("Add SNMP Community"), this.i18n.tr("Enter SNMP community string"), "", null);
        if (dlg.open() == 0) {
            String s = dlg.getValue();
            this.communities.add(s);
            this.communityList.setInput((Object)this.communities);
            this.setModified(1);
        }
    }

    private void removeCommunity() {
        IStructuredSelection selection = this.communityList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.communities.remove(o);
            }
            this.communityList.setInput((Object)this.communities);
            this.setModified(1);
        }
    }

    protected void moveCommunity(boolean up) {
        IStructuredSelection selection = this.communityList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.communities.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(this.communities, index - 1, index);
                    continue;
                }
                if (index + 1 == this.communities.size()) {
                    return;
                }
                Collections.swap(this.communities, index + 1, index);
            }
            this.communityList.setInput((Object)this.communities);
            this.setModified(1);
        }
    }

    private void createUSMCredentialsSection(Composite dialogArea) {
        Group clientArea = new Group(dialogArea, 0);
        clientArea.setText("USM credentials");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        clientArea.setLayoutData((Object)gd);
        String[] names = new String[]{"User name", "Auth type", "Priv type", "Auth secret", "Priv secret", "Comments"};
        int[] widths = new int[]{100, 100, 100, 100, 100, 100};
        this.usmCredentialList = new SortableTableViewer((Composite)clientArea, names, widths, 0, 1024, 67586);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        this.usmCredentialList.getTable().setLayoutData((Object)gd);
        this.usmCredentialList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.usmCredentialList.setLabelProvider((IBaseLabelProvider)new SnmpUsmCredentialsLabelProvider());
        this.usmCredentialList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttonsLeft = new Composite((Composite)clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gd);
        this.usmMoveUpButton = new Button(buttonsLeft, 8);
        this.usmMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.usmMoveUpButton.setLayoutData((Object)rd);
        this.usmMoveUpButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.usmMoveDownButton = new Button(buttonsLeft, 8);
        this.usmMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.usmMoveDownButton.setLayoutData((Object)rd);
        this.usmMoveDownButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttonsRight = new Composite((Composite)clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gd);
        this.usmAddButton = new Button(buttonsRight, 8);
        this.usmAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.usmAddButton.setLayoutData((Object)rd);
        this.usmAddButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.usmEditButton = new Button(buttonsRight, 8);
        this.usmEditButton.setText("Modify");
        rd = new RowData();
        rd.width = 90;
        this.usmEditButton.setLayoutData((Object)rd);
        this.usmEditButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.usmDeleteButton = new Button(buttonsRight, 8);
        this.usmDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.usmDeleteButton.setLayoutData((Object)rd);
        this.usmDeleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.usmCredentialList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addUsmCredentials() {
        EditSnmpUsmCredentialsDialog dlg = new EditSnmpUsmCredentialsDialog(this.getShell(), null);
        if (dlg.open() == 0) {
            SnmpUsmCredential cred = dlg.getCredentials();
            cred.setZoneId(this.zone.getUIN());
            this.usmCredentials.add(cred);
            this.usmCredentialList.setInput((Object)this.usmCredentials.toArray());
            this.setModified(2);
        }
    }

    private void editUsmCredentials() {
        IStructuredSelection selection = (IStructuredSelection)this.usmCredentialList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        EditSnmpUsmCredentialsDialog dlg = new EditSnmpUsmCredentialsDialog(this.getShell(), (SnmpUsmCredential)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.usmCredentialList.setInput((Object)this.usmCredentials.toArray());
            this.setModified(2);
        }
    }

    private void removeUsmCredentials() {
        IStructuredSelection selection = (IStructuredSelection)this.usmCredentialList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.usmCredentials.remove(o);
            }
            this.usmCredentialList.setInput((Object)this.usmCredentials.toArray());
            this.setModified(2);
        }
    }

    private void moveUsmCredentials(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.usmCredentialList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.usmCredentials.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(this.usmCredentials, index - 1, index);
                    continue;
                }
                if (index + 1 == this.usmCredentials.size()) {
                    return;
                }
                Collections.swap(this.usmCredentials, index + 1, index);
            }
            this.usmCredentialList.setInput((Object)this.usmCredentials.toArray());
            this.setModified(2);
        }
    }

    private void createPortSection(Composite dialogArea) {
        Group clientArea = new Group(dialogArea, 0);
        clientArea.setText("Ports");
        clientArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        this.portList = new TableViewer((Composite)clientArea, 67586);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        this.portList.getTable().setLayoutData((Object)gd);
        this.portList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonsLeft = new Composite((Composite)clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gd);
        this.portMoveUpButton = new Button(buttonsLeft, 8);
        this.portMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.portMoveUpButton.setLayoutData((Object)rd);
        this.portMoveUpButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.portMoveDownButton = new Button(buttonsLeft, 8);
        this.portMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.portMoveDownButton.setLayoutData((Object)rd);
        this.portMoveDownButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttonsRight = new Composite((Composite)clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gd);
        this.portAddButton = new Button(buttonsRight, 8);
        this.portAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.portAddButton.setLayoutData((Object)rd);
        this.portAddButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.portDeleteButton = new Button(buttonsRight, 8);
        this.portDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.portDeleteButton.setLayoutData((Object)rd);
        this.portDeleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.portList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addPort() {
        InputDialog dlg = new InputDialog(this.getShell(), this.i18n.tr("Add SNMP Port"), this.i18n.tr("Please enter SNMP port"), "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.ports.add(Integer.parseInt(value));
            this.portList.setInput((Object)this.ports.toArray());
            this.setModified(4);
        }
    }

    private void removePort() {
        IStructuredSelection selection = (IStructuredSelection)this.portList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.ports.remove((Integer)o);
            }
            this.portList.setInput((Object)this.ports.toArray());
            this.setModified(4);
        }
    }

    private void movePort(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.portList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.ports.indexOf((Integer)o);
                if (up) {
                    if (index < 1) continue;
                    Collections.swap(this.ports, index - 1, index);
                    continue;
                }
                if (index + 1 == this.ports.size()) continue;
                Collections.swap(this.ports, index + 1, index);
            }
            this.portList.setInput((Object)this.ports);
            this.setModified(4);
        }
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.modified == 0) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

