/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.xnap.commons.i18n.I18n;

public class ExpectedCapabilities
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(ExpectedCapabilities.class);
    private Node node;
    private Button checkboxAgent;
    private Button checkboxSNMP;
    private Button checkboxEtherNetIP;
    private Button checkboxModbus;
    private Button checkboxSSH;

    public ExpectedCapabilities(AbstractObject object) {
        super(LocalizationHelper.getI18n(ExpectedCapabilities.class).tr("Expected Capabilities"), object);
    }

    public String getId() {
        return "expected-capabilities";
    }

    public boolean isVisible() {
        return this.object instanceof Node;
    }

    public int getPriority() {
        return 22;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.node = (Node)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxAgent = new Button(dialogArea, 32);
        this.checkboxAgent.setText(this.i18n.tr("NetXMS &agent"));
        this.checkboxAgent.setSelection((this.node.getExpectedCapabilities() & 2L) != 0L);
        this.checkboxSNMP = new Button(dialogArea, 32);
        this.checkboxSNMP.setText(this.i18n.tr("&SNMP"));
        this.checkboxSNMP.setSelection((this.node.getExpectedCapabilities() & 1L) != 0L);
        this.checkboxEtherNetIP = new Button(dialogArea, 32);
        this.checkboxEtherNetIP.setText(this.i18n.tr("&EtherNet/IP"));
        this.checkboxEtherNetIP.setSelection((this.node.getExpectedCapabilities() & 0x800000L) != 0L);
        this.checkboxModbus = new Button(dialogArea, 32);
        this.checkboxModbus.setText(this.i18n.tr("&Modbus TCP"));
        this.checkboxModbus.setSelection((this.node.getExpectedCapabilities() & 0x1000000L) != 0L);
        this.checkboxSSH = new Button(dialogArea, 32);
        this.checkboxSSH.setText(this.i18n.tr("&SSH"));
        this.checkboxSSH.setSelection((this.node.getExpectedCapabilities() & 0x80L) != 0L);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        long capabilities = 0L;
        if (this.checkboxAgent.getSelection()) {
            capabilities |= 2L;
        }
        if (this.checkboxSNMP.getSelection()) {
            capabilities |= 1L;
        }
        if (this.checkboxEtherNetIP.getSelection()) {
            capabilities |= 0x800000L;
        }
        if (this.checkboxModbus.getSelection()) {
            capabilities |= 0x1000000L;
        }
        if (this.checkboxSSH.getSelection()) {
            capabilities |= 0x80L;
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setExpectedCapabilities(Long.valueOf(capabilities));
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

