/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TextBoxGeneral
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(TextBoxGeneral.class);
    private NetworkMapTextBox textBoxElement;
    private LabeledText text;
    private ColorSelector backgroundColor;
    private ColorSelector textColor;
    private ColorSelector borderColor;
    private Button checkShowBorder;
    private Spinner fontSize;
    private ObjectSelector drillDownObject;

    public TextBoxGeneral(NetworkMapTextBox textBoxElement) {
        super(LocalizationHelper.getI18n(TextBoxGeneral.class).tr("General"));
        this.textBoxElement = textBoxElement;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        layout.numColumns = 3;
        dialogArea.setLayout((Layout)layout);
        this.text = new LabeledText(dialogArea, 0, 2562);
        this.text.setLabel(this.i18n.tr("Text"));
        this.text.setText(this.textBoxElement.getText());
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 200;
        this.text.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.backgroundColor = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)this.i18n.tr("Background color"), (Object)gd);
        this.backgroundColor.setColorValue(ColorConverter.rgbFromInt((int)this.textBoxElement.getBackgroundColor()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textColor = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)this.i18n.tr("Text color"), (Object)gd);
        this.textColor.setColorValue(ColorConverter.rgbFromInt((int)this.textBoxElement.getTextColor()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.borderColor = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)this.i18n.tr("Border color"), (Object)gd);
        this.borderColor.setColorValue(ColorConverter.rgbFromInt((int)this.textBoxElement.getBorderColor()));
        this.checkShowBorder = new Button(dialogArea, 32);
        this.checkShowBorder.setText("Show border");
        this.checkShowBorder.setSelection(this.textBoxElement.isBorderRequired());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.checkShowBorder.setLayoutData((Object)gd);
        this.checkShowBorder.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fontSize = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)this.i18n.tr("Text size"), (int)1, (int)100, (Object)"WidgetHelper::default_layout_data");
        this.fontSize.setSelection(this.textBoxElement.getFontSize());
        this.drillDownObject = new ObjectSelector(dialogArea, 0, true);
        this.drillDownObject.setLabel(this.i18n.tr("Drill-down object"));
        this.drillDownObject.setObjectClass(AbstractObject.class);
        this.drillDownObject.setObjectId(this.textBoxElement.getDrillDownObjectId());
        this.drillDownObject.setClassFilter(ObjectSelectionDialog.createDashboardAndNetworkMapSelectionFilter());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.drillDownObject.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.textBoxElement.setText(this.text.getText());
        this.textBoxElement.setBackgroundColor(ColorConverter.rgbToInt((RGB)this.backgroundColor.getColorValue()));
        this.textBoxElement.setTextColor(ColorConverter.rgbToInt((RGB)this.textColor.getColorValue()));
        this.textBoxElement.setBorderRequired(this.checkShowBorder.getSelection());
        this.textBoxElement.setBorderColor(ColorConverter.rgbToInt((RGB)this.borderColor.getColorValue()));
        this.textBoxElement.setFontSize(this.fontSize.getSelection());
        this.textBoxElement.setDrillDownObjectId(this.drillDownObject.getObjectId());
        return true;
    }
}

