/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ServiceComponentsConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.propertypages.ServiceComponents;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ServiceComponents
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(ServiceComponents.class);
    private ServiceComponentsConfig config;
    private ObjectSelector objectSelector;
    private TitleConfigurator title;
    private Scale zoomLevelScale;
    private Spinner zoomLevelSpinner;
    private Button enableObjectDoubleClick;
    private Button checkShowStatusIcon;
    private Button checkShowStatusFrame;
    private Button checkShowStatusBkgnd;
    private Button checkTranslucentLabelBkgnd;
    private Combo objectDisplayMode;
    private Combo routingAlgorithm;
    private Combo layoutAlgorithm;
    private Button radioColorDefault;
    private Button radioColorCustom;
    private ColorSelector linkColor;

    public ServiceComponents(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(ServiceComponents.class).tr("Service Components"), elementConfig);
    }

    public String getId() {
        return "service-components";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof ServiceComponentsConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (ServiceComponentsConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, false, true);
        this.objectSelector.setLabel(this.i18n.tr("Container"));
        this.objectSelector.setClassFilter(ObjectSelectionDialog.createContainerSelectionFilter());
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        Label label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Zoom level (%)"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.zoomLevelScale = new Scale(dialogArea, 256);
        this.zoomLevelScale.setMinimum(10);
        this.zoomLevelScale.setMaximum(400);
        this.zoomLevelScale.setSelection(this.config.getZoomLevel());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.zoomLevelScale.setLayoutData((Object)gd);
        this.zoomLevelScale.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.zoomLevelSpinner = new Spinner(dialogArea, 2048);
        this.zoomLevelSpinner.setMinimum(10);
        this.zoomLevelSpinner.setMaximum(400);
        this.zoomLevelSpinner.setSelection(this.config.getZoomLevel());
        this.zoomLevelSpinner.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.enableObjectDoubleClick = new Button(dialogArea, 32);
        this.enableObjectDoubleClick.setText(this.i18n.tr("Enable double click action on objects"));
        this.enableObjectDoubleClick.setSelection(this.config.isObjectDoubleClickEnabled());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.enableObjectDoubleClick.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 2;
        this.layoutAlgorithm = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Layout algorithm"), (Object)gd);
        this.layoutAlgorithm.add(this.i18n.tr("Spring"));
        this.layoutAlgorithm.add(this.i18n.tr("Radial"));
        this.layoutAlgorithm.add(this.i18n.tr("Horizontal tree"));
        this.layoutAlgorithm.add(this.i18n.tr("Vertical tree"));
        this.layoutAlgorithm.add(this.i18n.tr("Sparse vertical tree"));
        this.layoutAlgorithm.select(this.config.getDefaultLayoutAlgorithm().getValue());
        Group objectDisplayGroup = new Group(dialogArea, 0);
        objectDisplayGroup.setText(this.i18n.tr("Default display options"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        objectDisplayGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        objectDisplayGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectDisplayMode = WidgetHelper.createLabeledCombo((Composite)objectDisplayGroup, (int)8, (String)this.i18n.tr("Display object as"), (Object)gd);
        this.objectDisplayMode.add(this.i18n.tr("Icons"));
        this.objectDisplayMode.add(this.i18n.tr("Small labels"));
        this.objectDisplayMode.add(this.i18n.tr("Large labels"));
        this.objectDisplayMode.add(this.i18n.tr("Status icons"));
        this.objectDisplayMode.select(this.config.getObjectDisplayMode().getValue());
        this.checkShowStatusIcon = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowStatusIcon.setText(this.i18n.tr("Show status icon"));
        this.checkShowStatusIcon.setSelection((this.config.getFlags() & 1) != 0);
        this.checkShowStatusFrame = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowStatusFrame.setText(this.i18n.tr("Show status frame"));
        this.checkShowStatusFrame.setSelection((this.config.getFlags() & 2) != 0);
        this.checkShowStatusBkgnd = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowStatusBkgnd.setText(this.i18n.tr("Show status background"));
        this.checkShowStatusBkgnd.setSelection((this.config.getFlags() & 4) != 0);
        this.checkTranslucentLabelBkgnd = new Button((Composite)objectDisplayGroup, 32);
        this.checkTranslucentLabelBkgnd.setText("Translucent label background");
        this.checkTranslucentLabelBkgnd.setSelection((this.config.getFlags() & 0x200) != 0);
        Group linkGroup = new Group(dialogArea, 0);
        linkGroup.setText(this.i18n.tr("Default connection options"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        linkGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        linkGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.routingAlgorithm = WidgetHelper.createLabeledCombo((Composite)linkGroup, (int)8, (String)this.i18n.tr("Routing algorithm"), (Object)gd);
        this.routingAlgorithm.add(this.i18n.tr("Direct"));
        this.routingAlgorithm.add(this.i18n.tr("Manhattan"));
        this.routingAlgorithm.select(this.config.getDefaultLinkRouting() - 1);
        3 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.radioColorDefault = new Button((Composite)linkGroup, 16);
        this.radioColorDefault.setText(this.i18n.tr("Default color"));
        this.radioColorDefault.setSelection(this.config.getDefaultLinkColor() < 0);
        this.radioColorDefault.addSelectionListener((SelectionListener)listener);
        gd = new GridData();
        gd.verticalIndent = 8;
        this.radioColorDefault.setLayoutData((Object)gd);
        this.radioColorCustom = new Button((Composite)linkGroup, 16);
        this.radioColorCustom.setText(this.i18n.tr("Custom color"));
        this.radioColorCustom.setSelection(this.config.getDefaultLinkColor() >= 0);
        this.radioColorCustom.addSelectionListener((SelectionListener)listener);
        this.linkColor = new ColorSelector((Composite)linkGroup);
        this.linkColor.setColorValue(ColorConverter.rgbFromInt((int)this.config.getDefaultLinkColor()));
        this.linkColor.setEnabled(this.config.getDefaultLinkColor() >= 0);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.linkColor.getButton().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setZoomLevel(this.zoomLevelSpinner.getSelection());
        this.config.setObjectDoubleClickEnabled(this.enableObjectDoubleClick.getSelection());
        this.config.setObjectDisplayMode(MapObjectDisplayMode.getByValue((int)this.objectDisplayMode.getSelectionIndex()));
        this.config.setDefaultLayoutAlgorithm(MapLayoutAlgorithm.getByValue((int)this.layoutAlgorithm.getSelectionIndex()));
        if (this.checkShowStatusIcon.getSelection()) {
            this.config.setFlags(this.config.getFlags() | 1);
        } else {
            this.config.setFlags(this.config.getFlags() & 0xFFFFFFFE);
        }
        if (this.checkShowStatusFrame.getSelection()) {
            this.config.setFlags(this.config.getFlags() | 2);
        } else {
            this.config.setFlags(this.config.getFlags() & 0xFFFFFFFD);
        }
        if (this.checkShowStatusBkgnd.getSelection()) {
            this.config.setFlags(this.config.getFlags() | 4);
        } else {
            this.config.setFlags(this.config.getFlags() & 0xFFFFFFFB);
        }
        if (this.checkTranslucentLabelBkgnd.getSelection()) {
            this.config.setFlags(this.config.getFlags() | 0x200);
        } else {
            this.config.setFlags(this.config.getFlags() & 0xFFFFFDFF);
        }
        this.config.setDefaultLinkRouting(this.routingAlgorithm.getSelectionIndex() + 1);
        if (this.radioColorDefault.getSelection()) {
            this.config.setDefaultLinkColor(-1);
        } else {
            this.config.setDefaultLinkColor(ColorConverter.rgbToInt((RGB)this.linkColor.getColorValue()));
        }
        return true;
    }
}

